/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.filter.Filters;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class DivideImpl
extends MathExpressionImpl
implements Divide {
    public DivideImpl(Expression expr1, Expression expr2) {
        super(expr1, expr2);
        this.expressionType = (short)108;
    }

    @Override
    public Object evaluate(Object feature) throws IllegalArgumentException {
        this.ensureOperandsSet();
        double leftDouble = Filters.number(this.getExpression1().evaluate(feature));
        double rightDouble = Filters.number(this.getExpression2().evaluate(feature));
        return this.number(leftDouble / rightDouble);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Divide)this, extraData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DivideImpl) {
            DivideImpl other = (DivideImpl)obj;
            return Utilities.equals(this.getExpression1(), other.getExpression1()) && Utilities.equals(this.getExpression2(), other.getExpression2());
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.getExpression1().hashCode();
        result = 37 * result + this.getExpression2().hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.getExpression1().toString() + "/" + this.getExpression2().toString() + ")";
    }
}

