/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.HashMap;
import java.util.Map;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;

public class PropertyDescriptorImpl
implements PropertyDescriptor {
    protected final PropertyType type;
    protected final Name name;
    protected final int minOccurs;
    protected final int maxOccurs;
    protected final boolean isNillable;
    final Map<Object, Object> userData;

    protected PropertyDescriptorImpl(PropertyType type, Name name, int min, int max, boolean isNillable) {
        this.type = type;
        this.name = name;
        this.minOccurs = min;
        this.maxOccurs = max;
        this.isNillable = isNillable;
        this.userData = new HashMap<Object, Object>();
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (max > 0 && max < min) {
            throw new IllegalArgumentException("max must be -1, or >= min");
        }
    }

    public PropertyType getType() {
        return this.type;
    }

    public Name getName() {
        return this.name;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyDescriptorImpl)) {
            return false;
        }
        PropertyDescriptorImpl other = (PropertyDescriptorImpl)obj;
        return Utilities.equals(this.type, other.type) && Utilities.equals(this.name, other.name) && this.minOccurs == other.minOccurs && this.maxOccurs == other.maxOccurs && this.isNillable == other.isNillable;
    }

    public int hashCode() {
        return 37 * this.minOccurs + 37 * this.maxOccurs ^ this.type.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName(this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.type != null) {
            sb.append(" <");
            sb.append(this.type.getName().getLocalPart());
            sb.append(":");
            sb.append(Classes.getShortName(this.type.getBinding()));
            sb.append(">");
        }
        if (this.isNillable) {
            sb.append(" nillable");
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            sb.append(" ");
            sb.append(this.minOccurs);
            sb.append(":");
            sb.append(this.maxOccurs);
        }
        if (this.userData != null && !this.userData.isEmpty()) {
            sb.append("\nuserData=(");
            for (Map.Entry<Object, Object> entry : this.userData.entrySet()) {
                sb.append("\n\t");
                sb.append(entry.getKey());
                sb.append(" ==> ");
                sb.append(entry.getValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

