/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.grid.Calculator2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class Interpolator2D
extends Calculator2D {
    private static final long serialVersionUID = 9028980295030908004L;
    private static final float ONE_EPSILON = 0.99999994f;
    private static Interpolation[] DEFAULTS;
    private final MathTransform2D toGrid;
    private final Interpolation interpolation;
    private final Interpolator2D fallback;
    private final int xmin;
    private final int ymin;
    private final int xmax;
    private final int ymax;
    private final int top;
    private final int left;
    private final Rectangle bounds;
    private transient double[][] doubles;
    private transient float[][] floats;
    private transient int[][] ints;
    private final BorderExtender borderExtender;
    public static int DEFAULT_BORDER_EXTENDER_TYPE;

    public static GridCoverage2D create(GridCoverage2D coverage) {
        if (DEFAULTS == null) {
            DEFAULTS = new Interpolation[]{Interpolation.getInstance(2), Interpolation.getInstance(1), Interpolation.getInstance(0)};
        }
        return Interpolator2D.create(coverage, DEFAULTS);
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation interpolation) {
        return Interpolator2D.create(coverage, new Interpolation[]{interpolation});
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation[] interpolations) {
        return Interpolator2D.create(coverage, interpolations, null);
    }

    public static GridCoverage2D create(GridCoverage2D coverage, Interpolation[] interpolations, BorderExtender be) {
        while (coverage instanceof Calculator2D) {
            coverage = ((Calculator2D)coverage).source;
        }
        if (interpolations.length == 0 || interpolations[0] instanceof InterpolationNearest) {
            return coverage;
        }
        return new Interpolator2D(coverage, interpolations, 0, be);
    }

    private Interpolator2D(GridCoverage2D coverage, Interpolation[] interpolations, int index, BorderExtender be) {
        super((CharSequence)null, coverage);
        int top;
        this.interpolation = interpolations[index];
        this.borderExtender = be == null ? BorderExtender.createInstance(DEFAULT_BORDER_EXTENDER_TYPE) : be;
        this.fallback = index + 1 < interpolations.length ? (interpolations[index + 1] instanceof InterpolationNearest ? this : new Interpolator2D(coverage, interpolations, index + 1, be)) : null;
        if (this.fallback != null && this.fallback != this) {
            this.toGrid = this.fallback.toGrid;
        } else {
            try {
                MathTransform2D transform = this.gridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
                this.toGrid = transform.inverse();
            }
            catch (NoninvertibleTransformException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        int left = this.interpolation.getLeftPadding();
        this.top = top = this.interpolation.getTopPadding();
        this.left = left;
        int x = this.image.getMinX();
        int y = this.image.getMinY();
        this.xmin = x + left;
        this.ymin = y + top;
        this.xmax = x + this.image.getWidth();
        this.ymax = y + this.image.getHeight();
        this.bounds = new Rectangle(0, 0, this.interpolation.getWidth(), this.interpolation.getHeight());
    }

    @Override
    protected GridCoverage2D specialize(GridCoverage2D view) {
        return Interpolator2D.create(view, this.getInterpolations());
    }

    Class<Interpolator2D> getViewClass() {
        return Interpolator2D.class;
    }

    public Interpolation[] getInterpolations() {
        ArrayList<Interpolation> interp = new ArrayList<Interpolation>(4);
        Interpolator2D scan = this;
        do {
            interp.add(this.interpolation);
            if (scan.fallback != scan) continue;
            interp.add(Interpolation.getInstance(0));
            break;
        } while ((scan = scan.fallback) != null);
        return interp.toArray(new Interpolation[interp.size()]);
    }

    @Override
    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), (Throwable)exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    @Override
    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), (Throwable)exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    @Override
    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        if (this.fallback != null) {
            dest = super.evaluate(coord, dest);
        }
        try {
            Point2D pixel = this.toGrid.transform(coord, null);
            double x = pixel.getX();
            double y = pixel.getY();
            if (!Double.isNaN(x) && !Double.isNaN(y) && (dest = this.interpolate(x, y, dest, 0, this.image.getNumBands())) != null) {
                return dest;
            }
        }
        catch (TransformException exception) {
            throw new CannotEvaluateException(this.formatEvaluateError(coord, false), (Throwable)exception);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    /*
     * Exception decompiling
     */
    private synchronized double[] interpolate(double x, double y, double[] dest, int band, int bandUp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private synchronized float[] interpolate(double x, double y, float[] dest, int band, int bandUp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized int[] interpolate(double x, double y, int[] dest, int band, int bandUp) {
        double x0 = Math.floor(x);
        double y0 = Math.floor(y);
        int ix = (int)x0;
        int iy = (int)y0;
        if (ix < this.xmin || ix >= this.xmax || iy < this.ymin || iy >= this.ymax) {
            return null;
        }
        Object samples = this.ints;
        if (samples == null) {
            int rowCount = this.interpolation.getHeight();
            int colCount = this.interpolation.getWidth();
            int[][] nArrayArray = new int[rowCount][];
            samples = nArrayArray;
            this.ints = nArrayArray;
            for (int i = 0; i < rowCount; ++i) {
                samples[i] = new int[colCount];
            }
        }
        if (dest == null) {
            dest = new int[bandUp];
        }
        this.bounds.x = ix - this.left;
        this.bounds.y = iy - this.top;
        RectIter iter = RectIterFactory.create(this.image.getExtendedData(this.bounds, this.borderExtender), this.bounds);
        while (band < bandUp) {
            iter.startLines();
            int j = 0;
            do {
                iter.startPixels();
                int[] row = samples[j++];
                int i = 0;
                do {
                    row[i++] = iter.getSample(band);
                } while (!iter.nextPixelDone());
                assert (i == row.length);
            } while (!iter.nextLineDone());
            assert (j == ((int[][])samples).length);
            int xfrac = (int)((x - x0) * (double)(1 << this.interpolation.getSubsampleBitsH()));
            int yfrac = (int)((y - y0) * (double)(1 << this.interpolation.getSubsampleBitsV()));
            dest[band] = this.interpolation.interpolate((int[][])samples, xfrac, yfrac);
            ++band;
        }
        return dest;
    }

    static {
        DEFAULT_BORDER_EXTENDER_TYPE = 1;
    }
}

