/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.AppSchemaResolver;

public class AppSchemaCache {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaCache.class.getPackage().getName());
    private static final int DEFAULT_DOWNLOAD_BLOCK_SIZE = 4096;
    private static final String[] GEOSERVER_DATA_DIRECTORY_FILENAMES = new String[]{"global.xml", "wcs.xml", "wfs.xml", "wms.xml"};
    private static final String[] GEOSERVER_DATA_DIRECTORY_SUBDIRECTORIES = new String[]{"styles", "workspaces"};
    private static final String CACHE_DIRECTORY_NAME = "app-schema-cache";
    private static boolean automaticConfigurationEnabled = true;
    private final File directory;
    private final boolean download;

    public AppSchemaCache(File directory, boolean download) {
        this.directory = directory;
        this.download = download;
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean isDownloadAllowed() {
        return this.download;
    }

    static void delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                AppSchemaCache.delete(f);
            }
        }
        file.delete();
    }

    static void store(File file, byte[] bytes) {
        OutputStream output = null;
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(file));
            output.write(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static byte[] download(String location) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return AppSchemaCache.download(locationUri);
    }

    static byte[] download(URI location) {
        return AppSchemaCache.download(location, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] download(URI location, int blockSize) {
        try {
            URL url = location.toURL();
            String protocol = url.getProtocol();
            if (protocol == null || !protocol.equals("http") && !protocol.equals("https")) {
                LOGGER.warning("Unexpected download URL protocol: " + protocol);
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                LOGGER.warning(String.format("Unexpected response \"%d %s\" while downloading %s", connection.getResponseCode(), connection.getResponseMessage(), location.toString()));
                return null;
            }
            InputStream input = null;
            LinkedList<byte[]> blocks = new LinkedList<byte[]>();
            try {
                byte[] block;
                int count;
                input = connection.getInputStream();
                while ((count = input.read(block = new byte[blockSize])) != -1) {
                    if (count == blockSize) {
                        blocks.add(block);
                        continue;
                    }
                    byte[] shortBlock = new byte[count];
                    System.arraycopy(block, 0, shortBlock, 0, count);
                    blocks.add(shortBlock);
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {}
                }
            }
            int totalCount = 0;
            for (byte[] b : blocks) {
                totalCount += b.length;
            }
            byte[] bytes = new byte[totalCount];
            int position = 0;
            for (byte[] b : blocks) {
                System.arraycopy(b, 0, bytes, position, b.length);
                position += b.length;
            }
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String resolveLocation(String location) {
        File file;
        String path = AppSchemaResolver.getSimpleHttpResourcePath(location);
        if (path == null) {
            return null;
        }
        String relativePath = path.substring(1);
        try {
            file = new File(this.getDirectory(), relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file.exists()) {
            return DataUtilities.fileToURL(file).toExternalForm();
        }
        if (this.isDownloadAllowed()) {
            byte[] bytes = AppSchemaCache.download(location);
            if (bytes == null) {
                return null;
            }
            AppSchemaCache.store(file, bytes);
            LOGGER.info("Cached application schema: " + location);
            return DataUtilities.fileToURL(file).toExternalForm();
        }
        return null;
    }

    public static AppSchemaCache buildAutomaticallyConfiguredUsingFileUrl(URL url) {
        if (!automaticConfigurationEnabled) {
            return null;
        }
        File file = DataUtilities.urlToFile(url);
        while (file != null) {
            if (AppSchemaCache.isSuitableDirectoryToContainCache(file)) {
                return new AppSchemaCache(new File(file, CACHE_DIRECTORY_NAME), true);
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static void disableAutomaticConfiguration() {
        automaticConfigurationEnabled = false;
    }

    public static void enableAutomaticConfiguration() {
        automaticConfigurationEnabled = true;
    }

    public static boolean isAutomaticConfigurationEnabled() {
        return automaticConfigurationEnabled;
    }

    static boolean isSuitableDirectoryToContainCache(File directory) {
        if (!directory.isDirectory()) {
            return false;
        }
        if (new File(directory, CACHE_DIRECTORY_NAME).isDirectory()) {
            return true;
        }
        for (String filename : GEOSERVER_DATA_DIRECTORY_FILENAMES) {
            File file = new File(directory, filename);
            if (file.isFile()) continue;
            return false;
        }
        for (String subdirectory : GEOSERVER_DATA_DIRECTORY_SUBDIRECTORIES) {
            File dir = new File(directory, subdirectory);
            if (dir.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

