/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AllHandler;
import org.geotools.xml.handlers.xsi.AnyAttributeHandler;
import org.geotools.xml.handlers.xsi.AttributeGroupHandler;
import org.geotools.xml.handlers.xsi.AttributeHandler;
import org.geotools.xml.handlers.xsi.ChoiceHandler;
import org.geotools.xml.handlers.xsi.ComplexContentHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.ExtensionHandler;
import org.geotools.xml.handlers.xsi.GroupHandler;
import org.geotools.xml.handlers.xsi.RestrictionHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.SequenceHandler;
import org.geotools.xml.handlers.xsi.SimpleContentHandler;
import org.geotools.xml.handlers.xsi.SimpleTypeHandler;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.SimpleTypeGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ComplexTypeHandler
extends XSIElementHandler {
    private static final long serialVersionUID = -2001189506633342497L;
    public static final String LOCALNAME = "complexType";
    public static final int ALL = 128;
    private static int offset = 0;
    private String id;
    private String name;
    private boolean abstracT;
    private boolean mixed;
    private int block;
    private int finaL;
    private List attrDecs = new LinkedList();
    private AnyAttributeHandler anyAttribute;
    private Object child;
    private int hashCodeOffset = ComplexTypeHandler.getOffset();
    private ComplexType cache = null;

    private static int getOffset() {
        return offset++;
    }

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) * (this.attrDecs == null ? 1 : ((Object)this.attrDecs).hashCode()) * (this.name == null ? 1 : this.name.hashCode()) + this.hashCodeOffset;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if ("group".equalsIgnoreCase(localName)) {
                GroupHandler sth = new GroupHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("all".equalsIgnoreCase(localName)) {
                AllHandler sth = new AllHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("choice".equalsIgnoreCase(localName)) {
                ChoiceHandler sth = new ChoiceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("sequence".equalsIgnoreCase(localName)) {
                SequenceHandler sth = new SequenceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("attribute".equalsIgnoreCase(localName)) {
                if (this.attrDecs == null) {
                    this.attrDecs = new LinkedList();
                }
                AttributeHandler ah = new AttributeHandler();
                this.attrDecs.add(ah);
                return ah;
            }
            if ("attributeGroup".equalsIgnoreCase(localName)) {
                if (this.attrDecs == null) {
                    this.attrDecs = new LinkedList();
                }
                AttributeGroupHandler ah = new AttributeGroupHandler();
                this.attrDecs.add(ah);
                return ah;
            }
            if ("anyAttribute".equalsIgnoreCase(localName)) {
                AnyAttributeHandler sth = new AnyAttributeHandler();
                if (this.anyAttribute != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.anyAttribute = sth;
                return sth;
            }
            if ("complexContent".equalsIgnoreCase(localName)) {
                ComplexContentHandler sth = new ComplexContentHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("simpleContent".equalsIgnoreCase(localName)) {
                SimpleContentHandler sth = new SimpleContentHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("complexType may only have one child declaration.");
                }
                this.child = sth;
                return sth;
            }
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) throws SAXException {
        String abstracT1;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        this.name = atts.getValue("", "name");
        if (this.name == null) {
            this.name = atts.getValue(namespaceURI, "name");
        }
        if ((abstracT1 = atts.getValue("", "abstract")) == null) {
            abstracT1 = atts.getValue(namespaceURI, "abstract");
        }
        this.abstracT = abstracT1 == null || "".equals(abstracT1) ? false : Boolean.valueOf(abstracT1);
        String block1 = atts.getValue("", "block");
        if (block1 == null) {
            block1 = atts.getValue(namespaceURI, "block");
        }
        this.block = ComplexTypeHandler.findBlock(block1);
        String finaL1 = atts.getValue("", "final");
        if (finaL1 == null) {
            finaL1 = atts.getValue(namespaceURI, "final");
        }
        this.finaL = ComplexTypeHandler.findFinal(finaL1);
        String mixed1 = atts.getValue("", "mixed");
        if (mixed1 == null) {
            mixed1 = atts.getValue(namespaceURI, "mixed");
        }
        this.mixed = mixed1 == null || "".equalsIgnoreCase(mixed1) ? false : Boolean.getBoolean(mixed1);
        this.block = ComplexTypeHandler.findBlock(block1);
        this.finaL = ComplexTypeHandler.findFinal(finaL1);
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public static int findBlock(String block) throws SAXException {
        if (block == null || "".equalsIgnoreCase(block)) {
            return 0;
        }
        if ("extension".equalsIgnoreCase(block)) {
            return 64;
        }
        if ("restriction".equalsIgnoreCase(block)) {
            return 4;
        }
        if ("#all".equalsIgnoreCase(block)) {
            return 128;
        }
        throw new SAXException("Unknown Block Type: '" + block + "'");
    }

    public static String writeBlock(int block) {
        switch (block) {
            case 64: {
                return "extension";
            }
            case 4: {
                return "restriction";
            }
            case 128: {
                return "#all";
            }
        }
        return "";
    }

    public static int findFinal(String finaL) throws SAXException {
        try {
            return ComplexTypeHandler.findBlock(finaL);
        }
        catch (SAXException e) {
            throw new SAXException("Unknown Final Type: '" + finaL + "'");
        }
    }

    public static String writeFinal(int finaL) {
        return ComplexTypeHandler.writeBlock(finaL);
    }

    public String getName() {
        return this.name;
    }

    protected ComplexType compress(SchemaHandler parent) throws SAXException {
        logger.fine("Start compressing ComplexType " + this.getName());
        if (this.cache != null) {
            return this.cache;
        }
        DefaultComplexType dct = new DefaultComplexType();
        dct.abstracT = this.abstracT;
        dct.anyAttributeNameSpace = this.anyAttribute != null ? this.anyAttribute.getNamespace() : null;
        HashSet<Object> attr = new HashSet<Object>();
        if (this.child instanceof SimpleContentHandler || this.child instanceof ComplexContentHandler) {
            if (this.child instanceof SimpleContentHandler) {
                logger.finest("SimpleContentHandler");
                SimpleContentHandler sch = (SimpleContentHandler)this.child;
                if (sch.getChild() instanceof ExtensionHandler) {
                    ExtensionHandler ext = (ExtensionHandler)sch.getChild();
                    if (ext.getAttributeDeclarations() != null) {
                        for (Object o : ext.getAttributeDeclarations()) {
                            if (o instanceof AttributeHandler) {
                                AttributeHandler ah = (AttributeHandler)o;
                                attr.add(ah.compress(parent));
                                continue;
                            }
                            AttributeGroupHandler agh = (AttributeGroupHandler)o;
                            AttributeGroup ag = agh.compress(parent);
                            attr.addAll(Arrays.asList(ag.getAttributes()));
                        }
                    }
                    SimpleType st = ext.getBase() == null || ext.getBase().equalsIgnoreCase("") ? ((SimpleTypeHandler)ext.getChild()).compress(parent) : parent.lookUpSimpleType(ext.getBase());
                    dct.parent = st;
                    dct.simple = true;
                } else {
                    RestrictionHandler rest = (RestrictionHandler)sch.getChild();
                    if (rest.getAttributeDeclarations() != null) {
                        for (Object o : rest.getAttributeDeclarations()) {
                            if (o instanceof AttributeHandler) {
                                AttributeHandler ah = (AttributeHandler)o;
                                attr.add(ah.compress(parent));
                                continue;
                            }
                            AttributeGroupHandler agh = (AttributeGroupHandler)o;
                            AttributeGroup ag = agh.compress(parent);
                            attr.addAll(Arrays.asList(ag.getAttributes()));
                        }
                    }
                    SimpleTypeGT st = new SimpleTypeGT(this.id, this.name, parent.getTargetNamespace(), 4, SimpleTypeHandler.getSimpleTypes(rest, parent), SimpleTypeHandler.getFacets(rest), this.finaL);
                    dct.parent = st;
                    dct.simple = true;
                }
                dct.mixed = true;
            } else {
                ComplexContentHandler cch = (ComplexContentHandler)this.child;
                if (cch.getChild() instanceof ExtensionHandler) {
                    ExtensionHandler ext = (ExtensionHandler)cch.getChild();
                    ComplexType ct = parent.lookUpComplexType(ext.getBase());
                    dct.parent = ct;
                    if (ct != null && ct.getAttributes() != null) {
                        Attribute[] it = ct.getAttributes();
                        for (int i = 0; i < it.length; ++i) {
                            attr.add(it[i]);
                        }
                    }
                    if (ext.getAttributeDeclarations() != null) {
                        for (Object o : ext.getAttributeDeclarations()) {
                            if (o instanceof AttributeHandler) {
                                AttributeHandler ah = (AttributeHandler)o;
                                attr.add(ah.compress(parent));
                                continue;
                            }
                            AttributeGroupHandler agh = (AttributeGroupHandler)o;
                            AttributeGroup ag = agh.compress(parent);
                            attr.addAll(Arrays.asList(ag.getAttributes()));
                        }
                    }
                    if (ct != null && ext.getChild() != null) {
                        logger.finest("Looked up " + ext.getBase() + " and found " + (ct == null ? null : ct.getName() + ":::" + ct.getNamespace()) + " for " + this.name);
                        ElementGrouping extensionBaseType = ct.getChild();
                        ElementGrouping extensionChild = ((ElementGroupingHandler)ext.getChild()).compress(parent);
                        dct.child = this.loadNewEG(extensionBaseType, extensionChild, parent);
                    } else if (ct != null) {
                        dct.child = ct.getChild();
                    }
                } else {
                    RestrictionHandler ext = (RestrictionHandler)cch.getChild();
                    if (ext.getAttributeDeclarations() != null) {
                        for (Object o : ext.getAttributeDeclarations()) {
                            if (o instanceof AttributeHandler) {
                                AttributeHandler ah = (AttributeHandler)o;
                                attr.add(ah.compress(parent));
                                continue;
                            }
                            AttributeGroupHandler agh = (AttributeGroupHandler)o;
                            AttributeGroup ag = agh.compress(parent);
                            attr.addAll(Arrays.asList(ag.getAttributes()));
                        }
                    }
                    dct.child = ext.getChild() == null ? null : ((ElementGroupingHandler)ext.getChild()).compress(parent);
                    dct.parent = parent.lookUpComplexType(ext.getBase());
                }
                if (dct.child == null) {
                    dct.child = new DefaultSequence();
                }
                dct.isDerived = true;
            }
        } else {
            if (this.attrDecs != null) {
                for (Object o : this.attrDecs) {
                    if (o instanceof AttributeHandler) {
                        AttributeHandler ah = (AttributeHandler)o;
                        attr.add(ah.compress(parent));
                        continue;
                    }
                    AttributeGroupHandler agh = (AttributeGroupHandler)o;
                    AttributeGroup ag = agh.compress(parent);
                    attr.addAll(Arrays.asList(ag.getAttributes()));
                }
            }
            dct.child = this.child != null ? ((ElementGroupingHandler)this.child).compress(parent) : new DefaultSequence();
        }
        dct.attributes = attr.toArray(new Attribute[attr.size()]);
        dct.namespace = parent.getTargetNamespace();
        dct.block = this.block;
        dct.finaL = this.finaL;
        dct.id = this.id;
        if (!dct.mixed) {
            dct.mixed = this.mixed;
        }
        dct.name = this.name;
        this.cache = dct;
        if (this.cache.getChild() == null && !this.abstracT && !dct.simple) {
            logger.warning(this.getName() + " :: " + parent.getTargetNamespace() + " should have a real child: ");
            throw new NullPointerException();
        }
        if (dct.parent == null && dct.simple) {
            logger.warning(this.getName() + " :: " + parent.getTargetNamespace() + " should have a real parent: ");
            throw new NullPointerException();
        }
        logger.fine("End compressing ComplexType " + this.getName());
        this.attrDecs = null;
        this.anyAttribute = null;
        this.child = null;
        return this.cache;
    }

    private ElementGrouping loadNewEG(ElementGrouping extensionBaseType, ElementGrouping extensionChild, SchemaHandler parent) throws SAXException {
        if (extensionChild == null) {
            if (extensionBaseType.getGrouping() == 2) {
                return ((Group)extensionBaseType).getChild();
            }
            return extensionBaseType;
        }
        switch (extensionBaseType.getGrouping()) {
            case 16: {
                logger.finest("ElementGrouping eg is CHOICE in loadNewEG");
                return new DefaultSequence((Choice)extensionBaseType, extensionChild);
            }
            case 2: {
                logger.finest("ElementGrouping eg is GROUP in loadNewEG");
                Group baseGroup = (Group)extensionBaseType;
                if (baseGroup.getChild() == null) {
                    return extensionChild;
                }
                return this.loadNewEG(baseGroup.getChild(), extensionChild, parent);
            }
            case 8: {
                logger.finest("ElementGrouping eg is SEQUENCE");
                return new DefaultSequence((Sequence)extensionBaseType, extensionChild);
            }
        }
        return extensionBaseType;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }

    private static class DefaultComplexType
    implements ComplexType {
        boolean isDerived = false;
        Type parent;
        String anyAttributeNameSpace;
        URI namespace;
        String id;
        String name;
        int block;
        int finaL;
        ElementGrouping child;
        boolean simple = false;
        Attribute[] attributes;
        boolean abstracT;
        boolean mixed;

        private DefaultComplexType() {
        }

        @Override
        public Element[] getChildElements() {
            if (this.child == null) {
                return null;
            }
            return this.getChildElements(this.child);
        }

        public Element[] getChildElements(ElementGrouping child11) {
            if (child11 == null) {
                return new Element[0];
            }
            switch (child11.getGrouping()) {
                case 32: {
                    return ((All)child11).getElements();
                }
                case 4: {
                    return null;
                }
                case 16: {
                    ElementGrouping[] children = ((Choice)child11).getChildren();
                    LinkedList<Element> l = new LinkedList<Element>();
                    for (int i = 0; i < children.length; ++i) {
                        Element[] t = this.getChildElements(children[i]);
                        if (t == null) continue;
                        l.addAll(Arrays.asList(t));
                    }
                    return l.size() > 0 ? l.toArray(new Element[l.size()]) : null;
                }
                case 1: {
                    return new Element[]{(Element)child11};
                }
                case 2: {
                    ElementGrouping c = ((Group)child11).getChild();
                    if (c == null) {
                        return new Element[0];
                    }
                    return this.getChildElements(c);
                }
                case 8: {
                    ElementGrouping[] children = ((Sequence)child11).getChildren();
                    LinkedList<Element> l = new LinkedList<Element>();
                    if (children != null) {
                        for (int i = 0; i < children.length; ++i) {
                            Element[] t = this.getChildElements(children[i]);
                            if (t == null) continue;
                            l.addAll(Arrays.asList(t));
                        }
                    }
                    return l.size() > 0 ? l.toArray(new Element[l.size()]) : null;
                }
            }
            return null;
        }

        @Override
        public boolean cache(Element e, Map m) {
            return true;
        }

        @Override
        public URI getNamespace() {
            return this.namespace;
        }

        @Override
        public Type getParent() {
            return this.parent;
        }

        @Override
        public boolean isDerived() {
            return this.isDerived;
        }

        @Override
        public Attribute[] getAttributes() {
            return this.attributes;
        }

        @Override
        public boolean isAbstract() {
            return this.abstracT;
        }

        @Override
        public int getBlock() {
            return this.block;
        }

        @Override
        public ElementGrouping getChild() {
            return this.child;
        }

        @Override
        public int getFinal() {
            return this.finaL;
        }

        @Override
        public boolean isMixed() {
            return this.mixed;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return this.anyAttributeNameSpace;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, final Attributes attrs, Map hints) throws OperationNotSupportedException, SAXException {
            Object[] values = null;
            XSIElementHandler.logger.finest("Getting value for " + this.name);
            if (this.isDerived || this.simple) {
                try {
                    Object v = this.parent.getValue(element, value, attrs, hints);
                    return v;
                }
                catch (SAXNotSupportedException snse) {
                    XSIElementHandler.logger.finest(snse.toString());
                }
            }
            if (this.simple) {
                return null;
            }
            if (element.getType() instanceof ComplexType && ((ComplexType)element.getType()).getChild() instanceof Choice) {
                if (value.length > 0) {
                    return value[0].getValue();
                }
            } else {
                values = new Object[value.length + 1];
                XSIElementHandler.logger.finest("Getting value for " + element.getName() + ":" + this.name);
                values[0] = new ElementValue(){

                    @Override
                    public Element getElement() {
                        return null;
                    }

                    @Override
                    public Object getValue() {
                        return attrs;
                    }
                };
                for (int i = 1; i < value.length + 1; ++i) {
                    values[i] = value[i - (this.isMixed() ? 0 : 1)].getValue();
                    XSIElementHandler.logger.finest("*" + (values[i] != null ? values[i].getClass().getName() : "null"));
                }
                if (this.isMixed()) {
                    values[values.length - 1] = value[0];
                }
            }
            return values;
        }

        @Override
        public Class getInstanceType() {
            return Object[].class;
        }

        @Override
        public Element findChildElement(String name1) {
            Element e;
            Element element = e = this.child == null ? null : this.child.findChildElement(name1);
            e = e == null ? (this.parent == null ? null : this.parent.findChildElement(name1)) : e;
            return e;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return this.parent != null && this.parent.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (this.parent != null && this.parent.canEncode(element, value, hints)) {
                this.parent.encode(element, value, output, hints);
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                Type type = element.getType();
                if (type instanceof SimpleType) {
                    SimpleType simple = (SimpleType)type;
                    simple.encode(element, value, output, hints);
                } else if (type instanceof ComplexType) {
                    ComplexType complex = (ComplexType)type;
                    Element[] children = complex.getChildElements();
                    boolean found = false;
                    for (int i = 0; i < children.length; ++i) {
                        Element child = children[i];
                        if (!child.getType().canEncode(child, value, hints)) continue;
                        child.getType().encode(child, value, output, hints);
                        found = true;
                    }
                    if (!found) {
                        throw new RuntimeException("It is not known how to print this element");
                    }
                } else {
                    throw new OperationNotSupportedException("It is not known how to print this element");
                }
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    private static class DefaultSequence
    implements Sequence {
        ElementGrouping[] children;
        String id;
        int maxOccurs;
        int minOccurs;

        private DefaultSequence() {
        }

        public DefaultSequence(Sequence sequence, ElementGrouping eg) {
            XSIElementHandler.logger.finest("merging sequence with an ElementGrouping");
            this.id = sequence.getId();
            this.maxOccurs = sequence.getMaxOccurs();
            this.minOccurs = sequence.getMinOccurs();
            if (sequence.getChildren() == null) {
                XSIElementHandler.logger.finest("Sequence children are null");
                this.children = new ElementGrouping[1];
                this.children[0] = eg;
                return;
            }
            if (eg.getGrouping() == 8) {
                int i;
                XSIElementHandler.logger.finest("Two sequences being merged");
                Sequence sq2 = (Sequence)eg;
                this.children = new ElementGrouping[sequence.getChildren().length + sq2.getChildren().length];
                XSIElementHandler.logger.finest("There are a total of " + this.children.length + " Children");
                for (i = 0; i < sequence.getChildren().length; ++i) {
                    this.children[i] = sequence.getChildren()[i];
                }
                for (i = 0; i < sq2.getChildren().length; ++i) {
                    this.children[sequence.getChildren().length + i] = sq2.getChildren()[i];
                }
            } else {
                this.children = new ElementGrouping[sequence.getChildren().length + 1];
                XSIElementHandler.logger.finest("There are a total of " + this.children.length + " Children");
                for (int i = 0; i < sequence.getChildren().length; ++i) {
                    this.children[i] = sequence.getChildren()[i];
                }
                this.children[sequence.getChildren().length] = eg;
            }
        }

        public DefaultSequence(Choice sequence, ElementGrouping eg) {
            this.id = sequence.getId();
            this.maxOccurs = sequence.getMaxOccurs();
            this.minOccurs = sequence.getMinOccurs();
            if (sequence.getChildren() == null) {
                this.children = new ElementGrouping[1];
                this.children[0] = eg;
                return;
            }
            this.children = new ElementGrouping[2];
            this.children[0] = sequence;
            this.children[1] = eg;
        }

        @Override
        public ElementGrouping[] getChildren() {
            return this.children;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public int getGrouping() {
            return 8;
        }

        @Override
        public Element findChildElement(String name) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.length; ++i) {
                Element t = this.children[i].findChildElement(name);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.length; ++i) {
                Element t = this.children[i].findChildElement(localName, namespaceURI);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }
}

