/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.OldReferencingObjectCache;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class ThreadedAuthorityFactory
extends AbstractAuthorityFactory
implements BufferedFactory {
    static final int DEFAULT_MAX = 20;
    AbstractAuthorityFactory backingStore;
    private final OldReferencingObjectCache objectCache;
    private final Map<IdentifiedObject, IdentifiedObject> findPool = new WeakHashMap<IdentifiedObject, IdentifiedObject>();

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory factory) {
        this(factory, 20);
    }

    protected ThreadedAuthorityFactory(AbstractAuthorityFactory factory, int maxStrongReferences) {
        super(factory.getPriority());
        while (factory instanceof ThreadedAuthorityFactory) {
            factory = ((ThreadedAuthorityFactory)factory).backingStore;
        }
        this.backingStore = factory;
        this.objectCache = new OldReferencingObjectCache(maxStrongReferences);
        this.completeHints();
    }

    ThreadedAuthorityFactory(int priority, int maxStrongReferences) {
        super(priority);
        this.objectCache = new OldReferencingObjectCache(maxStrongReferences);
    }

    final void completeHints() {
        if (this.backingStore instanceof DatumAuthorityFactory) {
            this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CSAuthorityFactory) {
            this.hints.put(Hints.CS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CRSAuthorityFactory) {
            this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CoordinateOperationAuthorityFactory) {
            this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.backingStore);
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object factory;
        try {
            factory = this.getBackingStore();
        }
        catch (FactoryException e) {
            factory = e;
        }
        return Collections.singleton(factory);
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            throw new FactoryException(Errors.format((int)42));
        }
        return this.backingStore;
    }

    @Override
    boolean isAvailable() {
        try {
            return this.getBackingStore().isAvailable();
        }
        catch (FactoryNotFoundException exception) {
        }
        catch (FactoryException exception) {
            Citation citation = this.getAuthority();
            Collection titles = citation.getAlternateTitles();
            InternationalString title = citation.getTitle();
            if (titles != null) {
                for (InternationalString candidate : titles) {
                    if (candidate.length() <= title.length()) continue;
                    title = candidate;
                }
            }
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)42, (Object)title);
            record.setSourceClassName(((Object)((Object)this)).getClass().getName());
            record.setSourceMethodName("isAvailable");
            record.setThrown(exception);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        return false;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory factory) {
        AbstractAuthorityFactory backingStore = this.backingStore;
        if (backingStore != null && backingStore.sameAuthorityCodes(factory)) {
            return true;
        }
        return super.sameAuthorityCodes(factory);
    }

    @Override
    public Citation getVendor() {
        return this.backingStore != null ? this.backingStore.getVendor() : super.getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.backingStore != null ? this.backingStore.getAuthority() : null;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return this.getBackingStore().getBackingStoreDescription();
    }

    public Set<String> getAuthorityCodes(Class type) throws FactoryException {
        return this.getBackingStore().getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getBackingStore().getDescriptionText(code);
    }

    @Override
    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        IdentifiedObject object = cached instanceof IdentifiedObject ? (IdentifiedObject)cached : this.getBackingStore().createObject(code);
        this.objectCache.put(key, object);
        return object;
    }

    @Override
    public synchronized Datum createDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Datum datum = cached instanceof Datum ? (Datum)cached : this.getBackingStore().createDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EngineeringDatum datum = cached instanceof EngineeringDatum ? (EngineeringDatum)cached : this.getBackingStore().createEngineeringDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized ImageDatum createImageDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ImageDatum datum = cached instanceof ImageDatum ? (ImageDatum)cached : this.getBackingStore().createImageDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized VerticalDatum createVerticalDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalDatum datum = cached instanceof VerticalDatum ? (VerticalDatum)cached : this.getBackingStore().createVerticalDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized TemporalDatum createTemporalDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TemporalDatum datum = cached instanceof TemporalDatum ? (TemporalDatum)cached : this.getBackingStore().createTemporalDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeodeticDatum datum = cached instanceof GeodeticDatum ? (GeodeticDatum)cached : this.getBackingStore().createGeodeticDatum(code);
        this.objectCache.put(key, datum);
        return datum;
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Ellipsoid ellipsoid = cached instanceof Ellipsoid ? (Ellipsoid)cached : this.getBackingStore().createEllipsoid(code);
        this.objectCache.put(key, ellipsoid);
        return ellipsoid;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        PrimeMeridian meridian = cached instanceof PrimeMeridian ? (PrimeMeridian)cached : this.getBackingStore().createPrimeMeridian(code);
        this.objectCache.put(key, meridian);
        return meridian;
    }

    @Override
    public synchronized Extent createExtent(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Extent extent = cached instanceof Extent ? (Extent)cached : this.getBackingStore().createExtent(code);
        this.objectCache.put(key, extent);
        return extent;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateSystem cs = cached instanceof CoordinateSystem ? (CoordinateSystem)cached : this.getBackingStore().createCoordinateSystem(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CartesianCS createCartesianCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CartesianCS cs = cached instanceof CartesianCS ? (CartesianCS)cached : this.getBackingStore().createCartesianCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized PolarCS createPolarCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        PolarCS cs = cached instanceof PolarCS ? (PolarCS)cached : this.getBackingStore().createPolarCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CylindricalCS createCylindricalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CylindricalCS cs = cached instanceof CylindricalCS ? (CylindricalCS)cached : this.getBackingStore().createCylindricalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized SphericalCS createSphericalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        SphericalCS cs = cached instanceof SphericalCS ? (SphericalCS)cached : this.getBackingStore().createSphericalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EllipsoidalCS cs = cached instanceof EllipsoidalCS ? (EllipsoidalCS)cached : this.getBackingStore().createEllipsoidalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized VerticalCS createVerticalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalCS cs = cached instanceof VerticalCS ? (VerticalCS)cached : this.getBackingStore().createVerticalCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized TimeCS createTimeCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TimeCS cs = cached instanceof TimeCS ? (TimeCS)cached : this.getBackingStore().createTimeCS(code);
        this.objectCache.put(key, cs);
        return cs;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateSystemAxis axis = cached instanceof CoordinateSystemAxis ? (CoordinateSystemAxis)cached : this.getBackingStore().createCoordinateSystemAxis(code);
        this.objectCache.put(key, axis);
        return axis;
    }

    @Override
    public synchronized Unit<?> createUnit(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        Unit<?> unit = cached instanceof Unit ? (Unit<?>)cached : this.getBackingStore().createUnit(code);
        this.objectCache.put(key, unit);
        return unit;
    }

    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateReferenceSystem crs = cached instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)cached : this.getBackingStore().createCoordinateReferenceSystem(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CompoundCRS crs = cached instanceof CompoundCRS ? (CompoundCRS)cached : this.getBackingStore().createCompoundCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized DerivedCRS createDerivedCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        DerivedCRS crs = cached instanceof DerivedCRS ? (DerivedCRS)cached : this.getBackingStore().createDerivedCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        EngineeringCRS crs = cached instanceof EngineeringCRS ? (EngineeringCRS)cached : this.getBackingStore().createEngineeringCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized GeographicCRS createGeographicCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeographicCRS crs = cached instanceof GeographicCRS ? (GeographicCRS)cached : this.getBackingStore().createGeographicCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        GeocentricCRS crs = cached instanceof GeocentricCRS ? (GeocentricCRS)cached : this.getBackingStore().createGeocentricCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ImageCRS createImageCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ImageCRS crs = cached instanceof ImageCRS ? (ImageCRS)cached : this.getBackingStore().createImageCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ProjectedCRS crs = cached instanceof ProjectedCRS ? (ProjectedCRS)cached : this.getBackingStore().createProjectedCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized TemporalCRS createTemporalCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        TemporalCRS crs = cached instanceof TemporalCRS ? (TemporalCRS)cached : this.getBackingStore().createTemporalCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized VerticalCRS createVerticalCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        VerticalCRS crs = cached instanceof VerticalCRS ? (VerticalCRS)cached : this.getBackingStore().createVerticalCRS(code);
        this.objectCache.put(key, crs);
        return crs;
    }

    @Override
    public synchronized ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        ParameterDescriptor parameter = cached instanceof ParameterDescriptor ? (ParameterDescriptor)cached : this.getBackingStore().createParameterDescriptor(code);
        this.objectCache.put(key, parameter);
        return parameter;
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        OperationMethod method = cached instanceof OperationMethod ? (OperationMethod)cached : this.getBackingStore().createOperationMethod(code);
        this.objectCache.put(key, method);
        return method;
    }

    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.objectCache.get(key);
        CoordinateOperation operation = cached instanceof CoordinateOperation ? (CoordinateOperation)cached : this.getBackingStore().createCoordinateOperation(code);
        this.objectCache.put(key, operation);
        return operation;
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        CodePair key = new CodePair(this.trimAuthority(sourceCode), this.trimAuthority(targetCode));
        Object cached = this.objectCache.get(key);
        Set<CoordinateOperation> operations = cached instanceof CoordinateOperation ? (Set<CoordinateOperation>)cached : Collections.unmodifiableSet(this.getBackingStore().createFromCoordinateReferenceSystemCodes(sourceCode, targetCode));
        this.objectCache.put(key, operations);
        return operations;
    }

    @Override
    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(this.getBackingStore().getIdentifiedObjectFinder(type));
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        if (this.backingStore != null) {
            this.backingStore.dispose();
            this.backingStore = null;
        }
        this.objectCache.clear();
        super.dispose();
    }

    private final class Finder
    extends IdentifiedObjectFinder.Adapter {
        Finder(IdentifiedObjectFinder finder) {
            super(finder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            Map map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                candidate = (IdentifiedObject)ThreadedAuthorityFactory.this.findPool.get(object);
            }
            if (candidate == null && (candidate = this.finder.find(object)) != null) {
                map = ThreadedAuthorityFactory.this.findPool;
                synchronized (map) {
                    ThreadedAuthorityFactory.this.findPool.put(object, candidate);
                }
            }
            return candidate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            Map map = ThreadedAuthorityFactory.this.findPool;
            synchronized (map) {
                candidate = (IdentifiedObject)ThreadedAuthorityFactory.this.findPool.get(object);
            }
            if (candidate != null) {
                return this.getIdentifier(candidate);
            }
            return this.finder.findIdentifier(object);
        }
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public int hashCode() {
            int code = 0;
            if (this.source != null) {
                code = this.source.hashCode();
            }
            if (this.target != null) {
                code += this.target.hashCode() * 37;
            }
            return code;
        }

        public boolean equals(Object other) {
            if (other instanceof CodePair) {
                CodePair that = (CodePair)other;
                return Utilities.equals((Object)this.source, (Object)that.source) && Utilities.equals((Object)this.target, (Object)that.target);
            }
            return false;
        }

        public String toString() {
            return this.source + " \u21e8 " + this.target;
        }
    }
}

