/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.ParseException;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class MathTransformParser
extends AbstractParser {
    protected final MathTransformFactory mtFactory;
    private String classification;
    private OperationMethod lastMethod;

    public MathTransformParser() {
        this(Symbols.DEFAULT);
    }

    public MathTransformParser(Symbols symbols) {
        this(symbols, ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public MathTransformParser(Symbols symbols, MathTransformFactory mathTransformFactory) {
        super(symbols);
        this.mtFactory = mathTransformFactory;
    }

    @Override
    protected Object parse(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean bl) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        Object object = element.peek();
        if (object instanceof Element) {
            String string = ((Element)object).keyword.trim().toUpperCase(this.symbols.locale);
            if ("PARAM_MT".equals(string)) {
                return this.parseParamMT(element);
            }
            if ("CONCAT_MT".equals(string)) {
                return this.parseConcatMT(element);
            }
            if ("INVERSE_MT".equals(string)) {
                return this.parseInverseMT(element);
            }
            if ("PASSTHROUGH_MT".equals(string)) {
                return this.parsePassThroughMT(element);
            }
        }
        if (bl) {
            throw element.parseFailed(null, Errors.format(187, object));
        }
        return null;
    }

    private MathTransform parseParamMT(Element element) throws ParseException {
        Object object;
        Element element2;
        ParameterValueGroup parameterValueGroup;
        Element element3 = element.pullElement("PARAM_MT");
        this.classification = element3.pullString("classification");
        try {
            parameterValueGroup = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element3.parseFailed(noSuchIdentifierException, null);
        }
        while ((element2 = element3.pullOptionalElement("PARAMETER")) != null) {
            object = element2.pullString("name");
            ParameterValue<?> parameterValue = parameterValueGroup.parameter((String)object);
            Class<?> clazz = parameterValue.getDescriptor().getValueClass();
            if (Integer.class.equals(clazz)) {
                parameterValue.setValue(element2.pullInteger("value"));
            } else if (Double.class.equals(clazz)) {
                parameterValue.setValue(element2.pullDouble("value"));
            } else {
                parameterValue.setValue(element2.pullString("value"));
            }
            element2.close();
        }
        element3.close();
        try {
            object = this.mtFactory.createParameterizedTransform(parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element3.parseFailed(factoryException, null);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return object;
    }

    private MathTransform parseInverseMT(Element element) throws ParseException {
        Element element2 = element.pullElement("INVERSE_MT");
        try {
            MathTransform mathTransform = this.parseMathTransform(element2, true).inverse();
            element2.close();
            return mathTransform;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed(noninvertibleTransformException, null);
        }
    }

    private MathTransform parsePassThroughMT(Element element) throws ParseException {
        Element element2 = element.pullElement("PASSTHROUGH_MT");
        int n = element.pullInteger("firstAffectedOrdinate");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        element2.close();
        try {
            return this.mtFactory.createPassThroughTransform(n, mathTransform, 0);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException, null);
        }
    }

    private MathTransform parseConcatMT(Element element) throws ParseException {
        MathTransform mathTransform;
        Element element2 = element.pullElement("CONCAT_MT");
        MathTransform mathTransform2 = this.parseMathTransform(element2, true);
        while ((mathTransform = this.parseMathTransform(element2, false)) != null) {
            try {
                mathTransform2 = this.mtFactory.createConcatenatedTransform(mathTransform2, mathTransform);
            }
            catch (FactoryException factoryException) {
                throw element2.parseFailed(factoryException, null);
            }
        }
        element2.close();
        return mathTransform2;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            for (OperationMethod operationMethod : this.mtFactory.getAvailableMethods(Operation.class)) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)operationMethod, this.classification)) continue;
                this.lastMethod = operationMethod;
                break;
            }
        }
        return this.lastMethod;
    }
}

