/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.vecmath.SingularMatrixException;
import org.geotools.factory.Hints;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultPassThroughOperation;
import org.geotools.referencing.operation.ProjectionAnalyzer;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Projection;

public class DefaultCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    static final int PRIORITY = 50;
    private static final double EPS = 1.0E-10;
    private static final Unit<Duration> MILLISECOND = SI.MILLI(SI.SECOND);
    private final String molodenskiMethod;
    private final boolean lenientDatumShift;

    public DefaultCoordinateOperationFactory() {
        this(null);
    }

    public DefaultCoordinateOperationFactory(Hints hints) {
        this(hints, 50);
    }

    public DefaultCoordinateOperationFactory(Hints hints, int n) {
        super(hints, n);
        String string = "Molodenski";
        boolean bl = false;
        if (hints != null) {
            Object object = hints.get(Hints.DATUM_SHIFT_METHOD);
            if (object instanceof String && (string = (String)object).trim().equalsIgnoreCase("Geocentric")) {
                string = null;
            }
            if ((object = hints.get(Hints.LENIENT_DATUM_SHIFT)) instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        this.molodenskiMethod = string;
        this.lenientDatumShift = bl;
        this.hints.put(Hints.DATUM_SHIFT_METHOD, string);
        this.hints.put(Hints.LENIENT_DATUM_SHIFT, bl);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        Object object;
        Object object2;
        DefaultCoordinateOperationFactory.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        DefaultCoordinateOperationFactory.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            int n = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem);
            assert (n == DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem2)) : n;
            return this.createFromAffineTransform(IDENTITY, coordinateReferenceSystem, coordinateReferenceSystem2, MatrixFactory.create(n + 1));
        }
        Object object3 = this.createFromDatabase(coordinateReferenceSystem, coordinateReferenceSystem2);
        if (object3 != null) {
            return object3;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS && DefaultCoordinateOperationFactory.containsIgnoreMetadata((List<SingleCRS>)(object3 = DefaultCompoundCRS.getSingleCRS(coordinateReferenceSystem)), object2 = DefaultCompoundCRS.getSingleCRS(coordinateReferenceSystem2))) {
            object = (CompoundCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof CompoundCRS) {
                CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem2;
                return this.createOperationStep((CompoundCRS)object, compoundCRS);
            }
            if (coordinateReferenceSystem2 instanceof SingleCRS) {
                SingleCRS singleCRS = (SingleCRS)coordinateReferenceSystem2;
                return this.createOperationStep((CompoundCRS)object, singleCRS);
            }
        }
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            object3 = (GeographicCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                object2 = (GeographicCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeographicCRS)object3, (GeographicCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof ProjectedCRS) {
                object2 = (ProjectedCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeographicCRS)object3, (ProjectedCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof GeocentricCRS) {
                object2 = (GeocentricCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeographicCRS)object3, (GeocentricCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                object2 = (VerticalCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeographicCRS)object3, (VerticalCRS)object2);
            }
        }
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            object3 = (ProjectedCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof ProjectedCRS) {
                object2 = (ProjectedCRS)coordinateReferenceSystem2;
                return this.createOperationStep((ProjectedCRS)object3, (ProjectedCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                object2 = (GeographicCRS)coordinateReferenceSystem2;
                return this.createOperationStep((ProjectedCRS)object3, (GeographicCRS)object2);
            }
        }
        if (coordinateReferenceSystem instanceof GeocentricCRS) {
            object3 = (GeocentricCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeocentricCRS) {
                object2 = (GeocentricCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeocentricCRS)object3, (GeocentricCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                object2 = (GeographicCRS)coordinateReferenceSystem2;
                return this.createOperationStep((GeocentricCRS)object3, (GeographicCRS)object2);
            }
        }
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            object3 = (VerticalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                object2 = (VerticalCRS)coordinateReferenceSystem2;
                return this.createOperationStep((VerticalCRS)object3, (VerticalCRS)object2);
            }
        }
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            object3 = (TemporalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                object2 = (TemporalCRS)coordinateReferenceSystem2;
                return this.createOperationStep((TemporalCRS)object3, (TemporalCRS)object2);
            }
        }
        if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
            object3 = (GeneralDerivedCRS)coordinateReferenceSystem2;
            object2 = object3.getBaseCRS();
            object = this.createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)object2);
            Conversion conversion = object3.getConversionFromBase();
            return this.concatenate((CoordinateOperation)object, conversion);
        }
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            object3 = (GeneralDerivedCRS)coordinateReferenceSystem;
            object2 = object3.getBaseCRS();
            object = this.createOperation((CoordinateReferenceSystem)object2, coordinateReferenceSystem2);
            CoordinateOperation coordinateOperation = object3.getConversionFromBase();
            MathTransform mathTransform = coordinateOperation.getMathTransform();
            try {
                mathTransform = mathTransform.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, (IdentifiedObject)object2), noninvertibleTransformException);
            }
            coordinateOperation = this.createFromMathTransform(INVERSE_OPERATION, coordinateReferenceSystem, (CoordinateReferenceSystem)object2, mathTransform);
            return this.concatenate(coordinateOperation, (CoordinateOperation)object);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            object3 = (CompoundCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof CompoundCRS) {
                object2 = (CompoundCRS)coordinateReferenceSystem2;
                return this.createOperationStep((CompoundCRS)object3, (CompoundCRS)object2);
            }
            if (coordinateReferenceSystem2 instanceof SingleCRS) {
                object2 = (SingleCRS)coordinateReferenceSystem2;
                return this.createOperationStep((CompoundCRS)object3, (SingleCRS)object2);
            }
        }
        if (coordinateReferenceSystem2 instanceof CompoundCRS) {
            object3 = (CompoundCRS)coordinateReferenceSystem2;
            if (coordinateReferenceSystem instanceof SingleCRS) {
                object2 = (SingleCRS)coordinateReferenceSystem;
                return this.createOperationStep((SingleCRS)object2, (CompoundCRS)object3);
            }
        }
        if (coordinateReferenceSystem == DefaultEngineeringCRS.GENERIC_2D || coordinateReferenceSystem2 == DefaultEngineeringCRS.GENERIC_2D || coordinateReferenceSystem == DefaultEngineeringCRS.GENERIC_3D || coordinateReferenceSystem2 == DefaultEngineeringCRS.GENERIC_3D) {
            int n = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem);
            int n2 = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem2);
            if (n2 == n) {
                object = MatrixFactory.create(n2 + 1, n + 1);
                return this.createFromAffineTransform(IDENTITY, coordinateReferenceSystem, coordinateReferenceSystem2, (Matrix)object);
            }
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, coordinateReferenceSystem2));
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws OperationNotFoundException, FactoryException {
        return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    private GeocentricCRS normalize(GeocentricCRS geocentricCRS, GeodeticDatum geodeticDatum) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS = DefaultCartesianCS.GEOCENTRIC;
        GeodeticDatum geodeticDatum2 = geocentricCRS.getDatum();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum2, geodeticDatum) && DefaultCoordinateOperationFactory.getGreenwichLongitude(geodeticDatum2.getPrimeMeridian()) == DefaultCoordinateOperationFactory.getGreenwichLongitude(geodeticDatum.getPrimeMeridian()) && DefaultCoordinateOperationFactory.hasStandardAxis(geocentricCRS.getCoordinateSystem(), defaultCartesianCS)) {
            return geocentricCRS;
        }
        CRSFactory cRSFactory = this.getFactoryContainer().getCRSFactory();
        return cRSFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geocentricCRS), geodeticDatum, defaultCartesianCS);
    }

    private GeographicCRS normalize(GeographicCRS geographicCRS, boolean bl) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        DefaultEllipsoidalCS defaultEllipsoidalCS2 = defaultEllipsoidalCS = ellipsoidalCS.getDimension() <= 2 ? DefaultEllipsoidalCS.GEODETIC_2D : DefaultEllipsoidalCS.GEODETIC_3D;
        if (bl && DefaultCoordinateOperationFactory.getGreenwichLongitude(geodeticDatum.getPrimeMeridian()) != 0.0) {
            geodeticDatum = new TemporaryDatum(geodeticDatum);
        } else if (DefaultCoordinateOperationFactory.hasStandardAxis(ellipsoidalCS, defaultEllipsoidalCS)) {
            return geographicCRS;
        }
        CRSFactory cRSFactory = this.getFactoryContainer().getCRSFactory();
        return cRSFactory.createGeographicCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS), geodeticDatum, defaultEllipsoidalCS);
    }

    private static boolean hasStandardAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n = coordinateSystem2.getDimension();
        if (coordinateSystem.getDimension() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem2.getAxis(i);
            if (coordinateSystemAxis.getDirection().equals(coordinateSystemAxis2.getDirection()) && coordinateSystemAxis.getUnit().equals(coordinateSystemAxis2.getUnit())) continue;
            return false;
        }
        return true;
    }

    private Matrix swapAndScaleAxis(EllipsoidalCS ellipsoidalCS, EllipsoidalCS ellipsoidalCS2, PrimeMeridian primeMeridian, PrimeMeridian primeMeridian2) throws OperationNotFoundException {
        Matrix matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2);
        int n = ellipsoidalCS2.getDimension();
        while (--n >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = ellipsoidalCS2.getAxis(n);
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            if (!AxisDirection.EAST.equals(axisDirection.absolute())) continue;
            Unit<Angle> unit = coordinateSystemAxis.getUnit().asType(Angle.class);
            double d = DefaultCoordinateOperationFactory.getGreenwichLongitude(primeMeridian, unit);
            double d2 = DefaultCoordinateOperationFactory.getGreenwichLongitude(primeMeridian2, unit);
            int n2 = matrix.getNumCol() - 1;
            double d3 = d - d2;
            if (AxisDirection.WEST.equals(axisDirection)) {
                d3 = -d3;
            }
            matrix.setElement(n, n2, d3 += matrix.getElement(n, n2));
        }
        return matrix;
    }

    private static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    private static double getGreenwichLongitude(PrimeMeridian primeMeridian) {
        return DefaultCoordinateOperationFactory.getGreenwichLongitude(primeMeridian, NonSI.DEGREE_ANGLE);
    }

    protected CoordinateOperation createOperationStep(TemporalCRS temporalCRS, TemporalCRS temporalCRS2) throws FactoryException {
        TemporalDatum temporalDatum;
        TemporalDatum temporalDatum2 = temporalCRS.getDatum();
        if (!CRS.equalsIgnoreMetadata(temporalDatum2, temporalDatum = temporalCRS2.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(temporalDatum2, temporalDatum));
        }
        TimeCS timeCS = temporalCRS.getCoordinateSystem();
        TimeCS timeCS2 = temporalCRS2.getCoordinateSystem();
        Unit<?> unit = timeCS2.getAxis(0).getUnit();
        double d = temporalDatum2.getOrigin().getTime() - temporalDatum.getOrigin().getTime();
        d = MILLISECOND.getConverterTo(unit).convert(d);
        Matrix matrix = this.swapAndScaleAxis(timeCS, timeCS2);
        int n = matrix.getNumCol() - 1;
        if (n >= 0) {
            double d2 = matrix.getElement(0, n);
            matrix.setElement(0, n, d2 + d);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, temporalCRS, temporalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS verticalCRS, VerticalCRS verticalCRS2) throws FactoryException {
        VerticalDatum verticalDatum;
        VerticalDatum verticalDatum2 = verticalCRS.getDatum();
        if (!CRS.equalsIgnoreMetadata(verticalDatum2, verticalDatum = verticalCRS2.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(verticalDatum2, verticalDatum));
        }
        VerticalCS verticalCS = verticalCRS.getCoordinateSystem();
        VerticalCS verticalCS2 = verticalCRS2.getCoordinateSystem();
        Matrix matrix = this.swapAndScaleAxis(verticalCS, verticalCS2);
        return this.createFromAffineTransform(AXIS_CHANGES, verticalCRS, verticalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, VerticalCRS verticalCRS) throws FactoryException {
        if (VerticalDatumType.ELLIPSOIDAL.equals(verticalCRS.getDatum().getVerticalDatumType())) {
            Matrix matrix = this.swapAndScaleAxis(geographicCRS.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
            return this.createFromAffineTransform(AXIS_CHANGES, geographicCRS, verticalCRS, matrix);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(geographicCRS, verticalCRS));
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, GeographicCRS geographicCRS2) throws FactoryException {
        IdentifiedObject identifiedObject;
        Object object;
        Object object2;
        Object object3;
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        EllipsoidalCS ellipsoidalCS2 = geographicCRS2.getCoordinateSystem();
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geographicCRS2.getDatum();
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        PrimeMeridian primeMeridian2 = geodeticDatum2.getPrimeMeridian();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum, geodeticDatum2)) {
            Matrix matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2, primeMeridian, primeMeridian2);
            return this.createFromAffineTransform(AXIS_CHANGES, geographicCRS, geographicCRS2, matrix);
        }
        if (this.molodenskiMethod != null) {
            object3 = DATUM_SHIFT;
            object2 = null;
            if (geodeticDatum instanceof DefaultGeodeticDatum) {
                object2 = ((DefaultGeodeticDatum)geodeticDatum).getBursaWolfParameters(geodeticDatum2);
            }
            if (object2 == null) {
                object = DefaultGeodeticDatum.getAffineTransform(geodeticDatum, geodeticDatum2);
                if (object != null) {
                    try {
                        object2 = new BursaWolfParameters(geodeticDatum2);
                        ((BursaWolfParameters)object2).setAffineTransform((Matrix)object, 1.0E-4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (this.lenientDatumShift) {
                    object2 = new BursaWolfParameters(geodeticDatum2);
                    object3 = ELLIPSOID_SHIFT;
                }
            }
            if (object2 != null && ((BursaWolfParameters)object2).isTranslation()) {
                object = geodeticDatum.getEllipsoid();
                identifiedObject = geodeticDatum2.getEllipsoid();
                if (((BursaWolfParameters)object2).isIdentity() && CRS.equalsIgnoreMetadata(object, identifiedObject)) {
                    Matrix matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2, primeMeridian, primeMeridian2);
                    return this.createFromAffineTransform((ReferenceIdentifier)object3, geographicCRS, geographicCRS2, matrix);
                }
                int n = DefaultCoordinateOperationFactory.getDimension(geographicCRS);
                int n2 = DefaultCoordinateOperationFactory.getDimension(geographicCRS2);
                ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters(this.molodenskiMethod);
                parameterValueGroup.parameter("src_semi_major").setValue(object.getSemiMajorAxis());
                parameterValueGroup.parameter("src_semi_minor").setValue(object.getSemiMinorAxis());
                parameterValueGroup.parameter("tgt_semi_major").setValue(identifiedObject.getSemiMajorAxis());
                parameterValueGroup.parameter("tgt_semi_minor").setValue(identifiedObject.getSemiMinorAxis());
                parameterValueGroup.parameter("dx").setValue(((BursaWolfParameters)object2).dx);
                parameterValueGroup.parameter("dy").setValue(((BursaWolfParameters)object2).dy);
                parameterValueGroup.parameter("dz").setValue(((BursaWolfParameters)object2).dz);
                parameterValueGroup.parameter("dim").setValue(n);
                if (n == n2) {
                    GeographicCRS geographicCRS3 = this.normalize(geographicCRS, true);
                    GeographicCRS geographicCRS4 = this.normalize(geographicCRS2, true);
                    CoordinateOperation coordinateOperation = this.createOperationStep(geographicCRS, geographicCRS3);
                    CoordinateOperation coordinateOperation2 = this.createFromParameters((ReferenceIdentifier)object3, geographicCRS3, geographicCRS4, parameterValueGroup);
                    CoordinateOperation coordinateOperation3 = this.createOperationStep(geographicCRS4, geographicCRS2);
                    return this.concatenate(coordinateOperation, coordinateOperation2, coordinateOperation3);
                }
            }
        }
        object3 = DefaultCartesianCS.GEOCENTRIC;
        object = this.getFactoryContainer().getCRSFactory();
        object2 = DefaultCoordinateOperationFactory.getGreenwichLongitude(primeMeridian2) == 0.0 ? object.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS2), geodeticDatum2, (CartesianCS)object3) : object.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS), geodeticDatum, (CartesianCS)object3);
        identifiedObject = this.createOperationStep(geographicCRS, (GeocentricCRS)object2);
        CoordinateOperation coordinateOperation = this.createOperationStep((GeocentricCRS)object2, geographicCRS2);
        return this.concatenate((CoordinateOperation)identifiedObject, coordinateOperation);
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS projectedCRS, ProjectedCRS projectedCRS2) throws FactoryException {
        CoordinateOperation coordinateOperation;
        CoordinateOperation coordinateOperation2;
        Matrix matrix = ProjectionAnalyzer.createLinearConversion(projectedCRS, projectedCRS2, 1.0E-10);
        if (matrix != null) {
            return this.createFromAffineTransform(AXIS_CHANGES, projectedCRS, projectedCRS2, matrix);
        }
        GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
        GeographicCRS geographicCRS2 = projectedCRS2.getBaseCRS();
        CoordinateOperation coordinateOperation3 = this.tryDB(projectedCRS, geographicCRS);
        if (coordinateOperation3 == null) {
            coordinateOperation3 = this.createOperationStep(projectedCRS, geographicCRS);
        }
        if ((coordinateOperation2 = this.tryDB(geographicCRS, geographicCRS2)) == null) {
            coordinateOperation2 = this.createOperationStep(geographicCRS, geographicCRS2);
        }
        if ((coordinateOperation = this.tryDB(geographicCRS2, projectedCRS2)) == null) {
            coordinateOperation = this.createOperationStep(geographicCRS2, projectedCRS2);
        }
        return this.concatenate(coordinateOperation3, coordinateOperation2, coordinateOperation);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, ProjectedCRS projectedCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = projectedCRS.getBaseCRS();
        Projection projection = projectedCRS.getConversionFromBase();
        CoordinateOperation coordinateOperation = this.tryDB(geographicCRS, geographicCRS2);
        if (coordinateOperation == null) {
            coordinateOperation = this.createOperationStep(geographicCRS, geographicCRS2);
        }
        return this.concatenate(coordinateOperation, projection);
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS projectedCRS, GeographicCRS geographicCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = projectedCRS.getBaseCRS();
        CoordinateOperation coordinateOperation = projectedCRS.getConversionFromBase();
        CoordinateOperation coordinateOperation2 = this.tryDB(geographicCRS2, geographicCRS);
        if (coordinateOperation2 == null) {
            coordinateOperation2 = this.createOperationStep(geographicCRS2, geographicCRS);
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(projectedCRS, geographicCRS2), noninvertibleTransformException);
        }
        coordinateOperation = this.createFromMathTransform(INVERSE_OPERATION, projectedCRS, geographicCRS2, mathTransform);
        return this.concatenate(coordinateOperation, coordinateOperation2);
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS geocentricCRS, GeocentricCRS geocentricCRS2) throws FactoryException {
        Matrix4 matrix4;
        GeodeticDatum geodeticDatum = geocentricCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geocentricCRS2.getDatum();
        CoordinateSystem coordinateSystem = geocentricCRS.getCoordinateSystem();
        CoordinateSystem coordinateSystem2 = geocentricCRS2.getCoordinateSystem();
        double d = DefaultCoordinateOperationFactory.getGreenwichLongitude(geodeticDatum.getPrimeMeridian());
        double d2 = DefaultCoordinateOperationFactory.getGreenwichLongitude(geodeticDatum2.getPrimeMeridian());
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum, geodeticDatum2) && d == d2) {
            Matrix matrix = this.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
            return this.createFromAffineTransform(AXIS_CHANGES, geocentricCRS, geocentricCRS2, matrix);
        }
        if (d != d2) {
            throw new OperationNotFoundException("Rotation of prime meridian not yet implemented");
        }
        DefaultCartesianCS defaultCartesianCS = DefaultCartesianCS.GEOCENTRIC;
        ReferenceIdentifier referenceIdentifier = DATUM_SHIFT;
        try {
            Matrix matrix = DefaultGeodeticDatum.getAffineTransform(TemporaryDatum.unwrap(geodeticDatum), TemporaryDatum.unwrap(geodeticDatum2));
            if (matrix == null) {
                if (this.lenientDatumShift) {
                    matrix = new Matrix4();
                    referenceIdentifier = ELLIPSOID_SHIFT;
                } else {
                    throw new OperationNotFoundException(Errors.format(18));
                }
            }
            Matrix matrix2 = this.swapAndScaleAxis(coordinateSystem, defaultCartesianCS);
            Matrix matrix3 = this.swapAndScaleAxis(defaultCartesianCS, coordinateSystem2);
            matrix4 = new Matrix4(matrix3);
            matrix4.multiply(matrix);
            matrix4.multiply(matrix2);
        }
        catch (SingularMatrixException singularMatrixException) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(geodeticDatum, geodeticDatum2), singularMatrixException);
        }
        return this.createFromAffineTransform(referenceIdentifier, geocentricCRS, geocentricCRS2, matrix4);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, GeocentricCRS geocentricCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = this.normalize(geographicCRS, true);
        GeodeticDatum geodeticDatum = geographicCRS2.getDatum();
        GeocentricCRS geocentricCRS2 = this.normalize(geocentricCRS, geodeticDatum);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters("Ellipsoid_To_Geocentric");
        parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        parameterValueGroup.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(geographicCRS2));
        CoordinateOperation coordinateOperation = this.createOperationStep(geographicCRS, geographicCRS2);
        CoordinateOperation coordinateOperation2 = this.createFromParameters(GEOCENTRIC_CONVERSION, geographicCRS2, geocentricCRS2, parameterValueGroup);
        CoordinateOperation coordinateOperation3 = this.createOperationStep(geocentricCRS2, geocentricCRS);
        return this.concatenate(coordinateOperation, coordinateOperation2, coordinateOperation3);
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS geocentricCRS, GeographicCRS geographicCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = this.normalize(geographicCRS, true);
        GeodeticDatum geodeticDatum = geographicCRS2.getDatum();
        GeocentricCRS geocentricCRS2 = this.normalize(geocentricCRS, geodeticDatum);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters("Geocentric_To_Ellipsoid");
        parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        parameterValueGroup.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(geographicCRS2));
        CoordinateOperation coordinateOperation = this.createOperationStep(geocentricCRS, geocentricCRS2);
        CoordinateOperation coordinateOperation2 = this.createFromParameters(GEOCENTRIC_CONVERSION, geocentricCRS2, geographicCRS2, parameterValueGroup);
        CoordinateOperation coordinateOperation3 = this.createOperationStep(geographicCRS2, geographicCRS);
        return this.concatenate(coordinateOperation, coordinateOperation2, coordinateOperation3);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS compoundCRS, SingleCRS singleCRS) throws FactoryException {
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        if (list.size() == 1) {
            return this.createOperation(list.get(0), singleCRS);
        }
        if (!DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS)) {
            List<SingleCRS> list2 = Collections.singletonList(singleCRS);
            return this.createOperationStep(compoundCRS, list, singleCRS, list2);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.getFactoryContainer().toGeodetic3D(compoundCRS);
        if (coordinateReferenceSystem != compoundCRS) {
            return this.createOperation(coordinateReferenceSystem, singleCRS);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(compoundCRS, singleCRS));
    }

    protected CoordinateOperation createOperationStep(SingleCRS singleCRS, CompoundCRS compoundCRS) throws FactoryException {
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        if (list.size() == 1) {
            return this.createOperation(singleCRS, list.get(0));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.getFactoryContainer().toGeodetic3D(compoundCRS);
        if (coordinateReferenceSystem != compoundCRS) {
            return this.createOperation(singleCRS, coordinateReferenceSystem);
        }
        List<SingleCRS> list2 = Collections.singletonList(singleCRS);
        return this.createOperationStep(singleCRS, list2, compoundCRS, list);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS compoundCRS, CompoundCRS compoundCRS2) throws FactoryException {
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        List<SingleCRS> list2 = DefaultCompoundCRS.getSingleCRS(compoundCRS2);
        if (list2.size() == 1) {
            return this.createOperation(compoundCRS, list2.get(0));
        }
        if (list.size() == 1) {
            return this.createOperation(list.get(0), compoundCRS2);
        }
        for (SingleCRS singleCRS : list2) {
            if (!DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS)) continue;
            ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer();
            CoordinateReferenceSystem coordinateReferenceSystem = referencingFactoryContainer.toGeodetic3D(compoundCRS);
            CoordinateReferenceSystem coordinateReferenceSystem2 = referencingFactoryContainer.toGeodetic3D(compoundCRS2);
            if (coordinateReferenceSystem != compoundCRS || coordinateReferenceSystem2 != compoundCRS2) {
                return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
            }
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(compoundCRS, compoundCRS2));
        }
        return this.createOperationStep(compoundCRS, list, compoundCRS2, list2);
    }

    private CoordinateOperation createOperationStep(CoordinateReferenceSystem coordinateReferenceSystem, List<SingleCRS> list, CoordinateReferenceSystem coordinateReferenceSystem2, List<SingleCRS> list2) throws FactoryException {
        int n;
        int n2;
        Object object;
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list2.size()];
        CoordinateOperation[] coordinateOperationArray = new CoordinateOperation[list2.size()];
        boolean[] blArray = new boolean[list.size()];
        int[] nArray = new int[DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem)];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            block13: {
                int n5 = 0;
                object = list2.get(i);
                OperationNotFoundException operationNotFoundException = null;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    CoordinateReferenceSystem coordinateReferenceSystem3 = list.get(n2);
                    int n6 = n5;
                    n5 += DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem3);
                    if (blArray[n2]) continue;
                    try {
                        coordinateOperationArray[n3] = this.createOperation(coordinateReferenceSystem3, (CoordinateReferenceSystem)object);
                    }
                    catch (OperationNotFoundException operationNotFoundException2) {
                        if (operationNotFoundException != null && n2 != i) continue;
                        operationNotFoundException = operationNotFoundException2;
                        continue;
                    }
                    coordinateReferenceSystemArray[n3++] = coordinateReferenceSystem3;
                    while (n6 < n5) {
                        nArray[n4++] = n6++;
                    }
                    break block13;
                }
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, coordinateReferenceSystem2), operationNotFoundException);
            }
            blArray[n2] = true;
        }
        assert (n3 == list2.size()) : n3;
        while (n3 != 0 && coordinateOperationArray[--n3].getMathTransform().isIdentity()) {
        }
        ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer();
        CoordinateOperation coordinateOperation = null;
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateReferenceSystem;
        object = MatrixFactory.create(n4 + 1, nArray.length + 1);
        object.setZero();
        object.setElement(n4, nArray.length, 1.0);
        for (n = 0; n < n4; ++n) {
            object.setElement(n, nArray[n], 1.0);
        }
        if (!object.isIdentity()) {
            coordinateReferenceSystem4 = coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystemArray[0] : referencingFactoryContainer.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem), coordinateReferenceSystemArray);
            coordinateOperation = this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, coordinateReferenceSystem4, (Matrix)object);
        }
        n2 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            CoordinateReferenceSystem coordinateReferenceSystem5;
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[i];
            Map<String, ?> map = AbstractIdentifiedObject.getProperties(coordinateOperation2);
            CoordinateReferenceSystem coordinateReferenceSystem6 = coordinateReferenceSystemArray[i];
            coordinateReferenceSystemArray[i] = coordinateReferenceSystem5 = (CoordinateReferenceSystem)list2.get(i);
            MathTransform mathTransform = coordinateOperation2.getMathTransform();
            CoordinateReferenceSystem coordinateReferenceSystem7 = i >= n3 ? coordinateReferenceSystem2 : (mathTransform.isIdentity() ? coordinateReferenceSystem4 : (coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystemArray[0] : referencingFactoryContainer.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem5), coordinateReferenceSystemArray)));
            n = n2;
            if (n != 0 || (n2 += DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem6)) != n4) {
                if (!(coordinateOperation2 instanceof Operation)) {
                    MathTransform mathTransform2 = coordinateOperation2.getMathTransform();
                    coordinateOperation2 = DefaultOperation.create(AbstractIdentifiedObject.getProperties(coordinateOperation2), coordinateOperation2.getSourceCRS(), coordinateOperation2.getTargetCRS(), mathTransform2, new DefaultOperationMethod(mathTransform2), coordinateOperation2.getClass());
                }
                mathTransform = this.getMathTransformFactory().createPassThroughTransform(n, mathTransform, n4 - n2);
                coordinateOperation2 = new DefaultPassThroughOperation(map, coordinateReferenceSystem4, coordinateReferenceSystem7, (Operation)coordinateOperation2, mathTransform);
            }
            coordinateOperation = coordinateOperation == null ? coordinateOperation2 : this.concatenate(coordinateOperation, coordinateOperation2);
            coordinateReferenceSystem4 = coordinateReferenceSystem7;
        }
        assert (n2 == n4) : n2;
        return coordinateOperation;
    }

    private static boolean needsGeodetic3D(List<SingleCRS> list, SingleCRS singleCRS) {
        boolean bl;
        Datum datum = singleCRS.getDatum();
        if (datum instanceof GeodeticDatum) {
            bl = true;
        } else if (datum instanceof VerticalDatum) {
            bl = false;
        } else {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (SingleCRS singleCRS2 : list) {
            boolean bl5;
            Datum datum2 = singleCRS2.getDatum();
            if (datum2 instanceof GeodeticDatum) {
                bl2 = true;
                bl5 = true;
            } else {
                if (!(datum2 instanceof VerticalDatum)) continue;
                bl3 = true;
                bl5 = false;
            }
            if (bl4 || bl5 != bl) continue;
            boolean bl6 = bl4 = !CRS.equalsIgnoreMetadata(datum2, datum);
            assert (Classes.sameInterfaces(datum2.getClass(), datum.getClass(), Datum.class));
        }
        return bl2 && bl3 && (bl4 || singleCRS.getCoordinateSystem().getDimension() >= 3);
    }

    private static boolean equalsIgnorePrimeMeridian(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        geodeticDatum = TemporaryDatum.unwrap(geodeticDatum);
        geodeticDatum2 = TemporaryDatum.unwrap(geodeticDatum2);
        if (CRS.equalsIgnoreMetadata(geodeticDatum.getEllipsoid(), geodeticDatum2.getEllipsoid())) {
            return AbstractIdentifiedObject.nameMatches((IdentifiedObject)geodeticDatum, geodeticDatum2.getName().getCode()) || AbstractIdentifiedObject.nameMatches((IdentifiedObject)geodeticDatum2, geodeticDatum.getName().getCode());
        }
        return false;
    }

    private static boolean containsIgnoreMetadata(List<SingleCRS> list, List<SingleCRS> list2) {
        block0: for (SingleCRS singleCRS : list2) {
            for (SingleCRS singleCRS2 : list) {
                if (!CRS.equalsIgnoreMetadata(singleCRS, singleCRS2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private final CoordinateOperation tryDB(SingleCRS singleCRS, SingleCRS singleCRS2) {
        return singleCRS == singleCRS2 ? null : this.createFromDatabase(singleCRS, singleCRS2);
    }

    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return null;
    }

    private static final class TemporaryDatum
    extends DefaultGeodeticDatum {
        private static final long serialVersionUID = -8964199103509187219L;
        private final GeodeticDatum datum;

        public TemporaryDatum(GeodeticDatum geodeticDatum) {
            super(AbstractCoordinateOperationFactory.getTemporaryName(geodeticDatum), geodeticDatum.getEllipsoid(), DefaultPrimeMeridian.GREENWICH);
            this.datum = geodeticDatum;
        }

        public static GeodeticDatum unwrap(GeodeticDatum geodeticDatum) {
            while (geodeticDatum instanceof TemporaryDatum) {
                geodeticDatum = ((TemporaryDatum)geodeticDatum).datum;
            }
            return geodeticDatum;
        }

        @Override
        public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
            if (super.equals(abstractIdentifiedObject, bl)) {
                GeodeticDatum geodeticDatum = ((TemporaryDatum)abstractIdentifiedObject).datum;
                return bl ? this.datum.equals(geodeticDatum) : CRS.equalsIgnoreMetadata(this.datum, geodeticDatum);
            }
            return false;
        }
    }
}

