/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.opengis.feature.Feature;

public class MaxFeaturesIterator<F extends Feature>
implements Iterator<F> {
    Iterator<F> delegate;
    long start;
    long end;
    long counter;

    public MaxFeaturesIterator(Iterator<F> iterator, long l, long l2) {
        this.delegate = iterator;
        this.start = l;
        this.end = l + l2;
        this.counter = 0L;
    }

    public Iterator<F> getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        if (this.counter < this.start) {
            this.skip();
        }
        return this.delegate.hasNext() && this.counter < this.end;
    }

    @Override
    public F next() {
        if (this.counter < this.start) {
            this.skip();
        }
        if (this.counter <= this.end) {
            ++this.counter;
            Feature feature = (Feature)this.delegate.next();
            return (F)feature;
        }
        return null;
    }

    private void skip() {
        if (this.counter < this.start) {
            while (this.delegate.hasNext() && this.counter < this.start) {
                ++this.counter;
                this.delegate.next();
            }
        }
    }
}

