/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.ParameterValueList;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    private ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.values = new ArrayList(list.size());
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            int n = generalParameterDescriptor.getMinimumOccurs();
            while (--n >= 0) {
                GeneralParameterValue generalParameterValue = generalParameterDescriptor.createValue();
                ParameterGroup.ensureNonNull("createValue", generalParameterValue);
                this.values.add(generalParameterValue);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup parameterDescriptorGroup, GeneralParameterValue[] generalParameterValueArray) {
        super(parameterDescriptorGroup);
        ParameterGroup.ensureNonNull("values", generalParameterValueArray);
        this.values = new ArrayList(generalParameterValueArray.length);
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            this.values.add(generalParameterValueArray[i]);
        }
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, int[]> linkedHashMap = new LinkedHashMap<GeneralParameterDescriptor, int[]>(Math.round((float)list.size() / 0.75f) + 1, 0.75f);
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            ParameterGroup.ensureNonNull("parameters", generalParameterDescriptor);
            linkedHashMap.put(generalParameterDescriptor, new int[1]);
        }
        ParameterGroup.ensureValidOccurs(generalParameterValueArray, linkedHashMap);
    }

    private static void ensureValidOccurs(GeneralParameterValue[] generalParameterValueArray, Map<GeneralParameterDescriptor, int[]> map) {
        Object object;
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            ParameterGroup.ensureNonNull("values", generalParameterValueArray, i);
            GeneralParameterDescriptor object2 = generalParameterValueArray[i].getDescriptor();
            object = map.get(object2);
            if (object == null) {
                String string = ParameterGroup.getName(object2);
                throw new InvalidParameterTypeException(Errors.format(65, string), string);
            }
            Object object3 = object;
            object3[0] = object3[0] + 1;
        }
        for (Map.Entry<GeneralParameterDescriptor, int[]> entry : map.entrySet()) {
            object = entry.getKey();
            int n = entry.getValue()[0];
            int n2 = object.getMinimumOccurs();
            int n3 = object.getMaximumOccurs();
            if (n >= n2 && n <= n3) continue;
            String string = ParameterGroup.getName((GeneralParameterDescriptor)object);
            throw new InvalidParameterCardinalityException(Errors.format(71, string, n, n2, n3), string);
        }
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    @Override
    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int n) throws IndexOutOfBoundsException {
        return this.values.get(n);
    }

    public ParameterValue parameter(String string) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", string);
        string = string.trim();
        for (GeneralParameterValue object : this.values) {
            if (!(object instanceof ParameterValue) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)object.getDescriptor(), string)) continue;
            return (ParameterValue)object;
        }
        for (GeneralParameterDescriptor generalParameterDescriptor : this.getDescriptor().descriptors()) {
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterDescriptor, string)) continue;
            ParameterValue parameterValue = ((ParameterDescriptor)generalParameterDescriptor).createValue();
            this.values.add(parameterValue);
            return parameterValue;
        }
        throw new ParameterNotFoundException(Errors.format(99, string), string);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ParameterGroup.ensureNonNull("name", string);
        string = string.trim();
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        Object object = this.values.iterator();
        while (object.hasNext()) {
            GeneralParameterValue generalParameterValue = object.next();
            if (!(generalParameterValue instanceof ParameterValueGroup) || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) continue;
            arrayList.add((ParameterValueGroup)generalParameterValue);
        }
        if (arrayList.isEmpty() && !((object = ((ParameterDescriptorGroup)this.descriptor).descriptor(string)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format(99, string), string);
        }
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup parameterGroup = (ParameterGroup)object;
            return Utilities.equals(this.values, parameterGroup.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup parameterGroup = (ParameterGroup)super.clone();
        parameterGroup.values = (ArrayList)parameterGroup.values.clone();
        int n = parameterGroup.values.size();
        while (--n >= 0) {
            parameterGroup.values.set(n, parameterGroup.values.get(n).clone());
        }
        parameterGroup.asList = null;
        return parameterGroup;
    }
}

