/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;

public class CachedQuadTree {
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    MemoryNode root;
    Indices offsets = new Indices();

    public CachedQuadTree(QuadTree quadTree) throws IOException {
        this.root = this.cloneAndTranslate(quadTree.getRoot(), quadTree.getIndexfile());
    }

    public Envelope getBounds() {
        return new Envelope((double)this.root.minx, (double)this.root.maxx, (double)this.root.miny, (double)this.root.maxy);
    }

    private MemoryNode cloneAndTranslate(Node node, IndexFile indexFile) throws IOException {
        node.pack();
        int[] nArray = node.getShapesId();
        int n = -1;
        int n2 = -1;
        if (nArray != null && nArray.length > 0) {
            n = this.offsets.size();
            for (int i = 0; i < nArray.length; ++i) {
                this.offsets.add(indexFile.getOffsetInBytes(nArray[i]));
            }
            n2 = this.offsets.size();
        }
        node.clean();
        MemoryNode memoryNode = new MemoryNode(node.getBounds(), n, n2, node.getNumSubNodes());
        for (int i = 0; i < node.getNumSubNodes(); ++i) {
            memoryNode.subnodes[i] = this.cloneAndTranslate(node.getSubNode(i), indexFile);
        }
        node.clearSubNodes();
        return memoryNode;
    }

    public CloseableIterator<Data> search(Envelope envelope) throws StoreException {
        final Indices indices = new Indices();
        this.collectIndices(indices, this.root, envelope);
        indices.sort();
        final Data data = new Data(DATA_DEFINITION);
        return new CloseableIterator<Data>(){
            boolean read = true;
            int idx = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Data next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.read = true;
                return data;
            }

            @Override
            public boolean hasNext() {
                if (!this.read) {
                    return true;
                }
                if (this.idx >= indices.size()) {
                    return false;
                }
                try {
                    data.clear();
                    data.addValue(0);
                    data.addValue(indices.get(this.idx));
                    ++this.idx;
                    this.read = false;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                return true;
            }

            @Override
            public void close() throws IOException {
                indices.clear();
            }
        };
    }

    void collectIndices(Indices indices, MemoryNode memoryNode, Envelope envelope) throws StoreException {
        if (!memoryNode.intersects(envelope)) {
            return;
        }
        if (memoryNode.start > -1 && memoryNode.end >= memoryNode.start) {
            for (int i = memoryNode.start; i < memoryNode.end; ++i) {
                indices.add(this.offsets.get(i));
            }
        }
        for (MemoryNode memoryNode2 : memoryNode.subnodes) {
            this.collectIndices(indices, memoryNode2, envelope);
        }
    }

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }

    static class MemoryNode {
        float minx;
        float miny;
        float maxx;
        float maxy;
        int start;
        int end;
        MemoryNode[] subnodes;

        public MemoryNode(Envelope envelope, int n, int n2, int n3) {
            this.minx = (float)envelope.getMinX();
            this.miny = (float)envelope.getMinY();
            this.maxx = (float)envelope.getMaxX();
            this.maxy = (float)envelope.getMaxY();
            this.start = n;
            this.end = n2;
            this.subnodes = new MemoryNode[n3];
        }

        public boolean intersects(Envelope envelope) {
            return new Envelope((double)this.minx, (double)this.maxx, (double)this.miny, (double)this.maxy).intersects(envelope);
        }
    }

    class Indices {
        int curr = -1;
        int[] indices = new int[100];

        int size() {
            return this.curr + 1;
        }

        void add(int n) {
            ++this.curr;
            if (this.curr * 2 + 1 >= this.indices.length) {
                int n2 = this.indices.length * 3 / 2;
                if (n2 < 10) {
                    n2 = 10;
                }
                int[] nArray = new int[n2];
                System.arraycopy(this.indices, 0, nArray, 0, this.indices.length);
                this.indices = nArray;
            }
            this.indices[this.curr] = n;
        }

        void clear() {
            this.curr = -1;
        }

        int get(int n) {
            return this.indices[n];
        }

        void sort() {
            Arrays.sort(this.indices, 0, this.curr + 1);
        }
    }
}

