/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class CollectionFeatureSource
implements SimpleFeatureSource {
    protected SimpleFeatureCollection collection;
    protected List<FeatureListener> listeners = null;
    private QueryCapabilities capabilities;
    private Set<RenderingHints.Key> hints;

    public CollectionFeatureSource(SimpleFeatureCollection simpleFeatureCollection) {
        this.collection = simpleFeatureCollection;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.collection.getSchema();
    }

    @Override
    public synchronized void addFeatureListener(FeatureListener featureListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(featureListener);
    }

    @Override
    public synchronized void removeFeatureListener(FeatureListener featureListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(featureListener);
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.collection.getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    @Override
    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        throw new UnsupportedOperationException("CollectionFeatureSource is an inmemory wrapper");
    }

    @Override
    public Name getName() {
        return ((SimpleFeatureType)this.collection.getSchema()).getName();
    }

    @Override
    public synchronized QueryCapabilities getQueryCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new QueryCapabilities(){

                @Override
                public boolean isOffsetSupported() {
                    return true;
                }

                @Override
                public boolean isReliableFIDSupported() {
                    return true;
                }

                @Override
                public boolean supportsSorting(SortBy[] sortByArray) {
                    return true;
                }
            };
        }
        return this.capabilities;
    }

    @Override
    public synchronized Set<RenderingHints.Key> getSupportedHints() {
        if (this.hints == null) {
            HashSet hashSet = new HashSet();
            this.hints = Collections.unmodifiableSet(hashSet);
        }
        return this.hints;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CollectionFeatureSource:");
        stringBuilder.append(this.collection);
        return stringBuilder.toString();
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) {
        Query query = new Query(this.getSchema().getTypeName(), filter);
        return this.getFeatures(query);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query object) {
        Object object2;
        Object object3;
        Object object4;
        int n = ((Query)(object = DataUtilities.resolvePropertyNames((Query)object, this.getSchema()))).getStartIndex() != null ? ((Query)object).getStartIndex() : 0;
        if (n > 0 & ((Query)object).getSortBy() == null) {
            if (!this.getQueryCapabilities().supportsSorting(((Query)object).getSortBy())) {
                throw new IllegalStateException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            object4 = new Query((Query)object);
            ((Query)object4).setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
            object = object4;
        }
        object4 = this.collection;
        if (((Query)object).getFilter() != null && ((Query)object).getFilter().equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (((Query)object).getFilter() != null && ((Query)object).getFilter() != Filter.INCLUDE) {
            object4 = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)object4, ((Query)object).getFilter());
        }
        if (((Query)object).getCoordinateSystemReproject() != null) {
            object4 = new ReprojectingFeatureCollection((SimpleFeatureCollection)object4, ((Query)object).getCoordinateSystemReproject());
        }
        if (((Query)object).getSortBy() != null && ((Query)object).getSortBy().length != 0) {
            object3 = object4.toArray(new SimpleFeature[object4.size()]);
            for (SortBy sortBy : ((Query)object).getSortBy()) {
                Comparator<SimpleFeature> comparator = DataUtilities.sortComparator(sortBy);
                Arrays.sort(object3, comparator);
            }
            object2 = new ArrayList<SimpleFeature>(Arrays.asList(object3));
            object4 = new ListFeatureCollection(this.getSchema(), (List<SimpleFeature>)object2);
        }
        if (n > 0 || !((Query)object).isMaxFeaturesUnlimited()) {
            long l = Long.MAX_VALUE;
            if (!((Query)object).isMaxFeaturesUnlimited()) {
                l = ((Query)object).getMaxFeatures();
            }
            object4 = new MaxSimpleFeatureCollection((SimpleFeatureCollection)object4, n, l);
        }
        if (((Query)object).getPropertyNames() != Query.ALL_NAMES && !(object2 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)(object3 = (SimpleFeatureType)object4.getSchema()), ((Query)object).getPropertyNames())).equals(object3)) {
            object4 = new ReTypingFeatureCollection((SimpleFeatureCollection)object4, (SimpleFeatureType)object2);
        }
        return new SubCollection((Query)object, (SimpleFeatureCollection)object4);
    }

    protected class SubCollection
    extends DecoratingSimpleFeatureCollection {
        private Query query;

        protected SubCollection(Query query, SimpleFeatureCollection simpleFeatureCollection) {
            super(simpleFeatureCollection);
            this.query = query;
        }

        @Override
        public SimpleFeatureCollection subCollection(Filter filter) {
            Query query = new Query(this.getSchema().getTypeName(), filter);
            Query query2 = DataUtilities.mixQueries(this.query, query, query.getHandle());
            return CollectionFeatureSource.this.getFeatures(query2);
        }
    }
}

