/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.Parameter;
import org.geotools.factory.Factory;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.InternationalString;

public interface DataAccessFactory
extends Factory {
    public DataAccess<? extends FeatureType, ? extends Feature> createDataStore(Map<String, Serializable> var1) throws IOException;

    public String getDescription();

    public boolean isAvailable();

    public static class Param
    extends Parameter {
        public Param(String string, Class<?> clazz, String string2, boolean bl) {
            this(string, clazz, string2, bl, null);
        }

        public Param(String string, Class<?> clazz, String string2, boolean bl, Object object) {
            this(string, clazz, string2 == null ? null : new SimpleInternationalString(string2), bl, object, null);
        }

        public Param(String string, Class clazz, String string2, boolean bl, Object object, Map<String, ?> map) {
            this(string, clazz, new SimpleInternationalString(string2), bl, object, map);
        }

        public Param(String string, Class clazz, InternationalString internationalString, boolean bl, Object object, Map<String, ?> map) {
            super(string, clazz, new SimpleInternationalString(string), internationalString, bl, 1, 1, object, map);
        }

        public Object lookUp(Map<String, ?> map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object object = map.get(this.key);
            if (object == null) {
                return null;
            }
            if (object instanceof String && this.type != String.class) {
                object = this.handle((String)object);
            }
            if (object == null) {
                return null;
            }
            if (!this.type.isInstance(object)) {
                throw new IOException(this.type.getName() + " required for parameter " + this.key + ": not " + object.getClass().getName());
            }
            return object;
        }

        public String text(Object object) {
            return object.toString();
        }

        public Object handle(String string) throws IOException {
            if (string == null) {
                return null;
            }
            if (this.type == String.class) {
                return string;
            }
            if (string.length() == 0) {
                return null;
            }
            if (this.type.isArray()) {
                Object object;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (stringTokenizer.hasMoreTokens()) {
                    Object object2;
                    object = stringTokenizer.nextToken();
                    try {
                        object2 = this.type.getComponentType() == String.class ? object : this.parse((String)object);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        throw new DataSourceException("Problem creating " + this.type.getName() + " from '" + string + "'", throwable);
                    }
                    arrayList.add(object2);
                }
                object = Array.newInstance(this.type.getComponentType(), arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Array.set(object, i, arrayList.get(i));
                }
                return object;
            }
            try {
                return this.parse(string);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Problem creating " + this.type.getName() + " from '" + string + "'", throwable);
            }
        }

        public Object parse(String string) throws Throwable {
            Constructor constructor;
            try {
                constructor = this.type.getConstructor(String.class);
            }
            catch (SecurityException securityException) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            try {
                return constructor.newInstance(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + string + "'", illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + string + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + string + "'", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.key);
            stringBuffer.append('=');
            stringBuffer.append(this.type.getName());
            stringBuffer.append(' ');
            if (this.required) {
                stringBuffer.append("REQUIRED ");
            }
            stringBuffer.append(this.description);
            return stringBuffer.toString();
        }
    }
}

