/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public abstract class AbstractDataStore
implements DataStore {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.data");
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected final boolean isWriteable;
    private InProcessLockingManager lockingManager;

    public AbstractDataStore() {
        this(true);
    }

    public AbstractDataStore(boolean bl) {
        this.isWriteable = bl;
        this.lockingManager = this.createLockingManager();
    }

    protected InProcessLockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    protected Map createMetadata(String string) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public abstract String[] getTypeNames() throws IOException;

    public ServiceInfo getInfo() {
        DefaultServiceInfo defaultServiceInfo = new DefaultServiceInfo();
        defaultServiceInfo.setDescription("Features from " + this.getClass().getSimpleName());
        defaultServiceInfo.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return defaultServiceInfo;
    }

    @Override
    public abstract SimpleFeatureType getSchema(String var1) throws IOException;

    protected abstract FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String var1) throws IOException;

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string) throws IOException {
        throw new UnsupportedOperationException("FeatureWriter not implemented - is this a Read-only DataStore?");
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String string, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("FeatureWriter not supported");
    }

    @Override
    public void createSchema(SimpleFeatureType simpleFeatureType) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    @Override
    public void updateSchema(String string, SimpleFeatureType simpleFeatureType) {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    @Override
    public SimpleFeatureSource getFeatureSource(final String string) throws IOException {
        final SimpleFeatureType simpleFeatureType = this.getSchema(string);
        if (this.isWriteable) {
            if (this.lockingManager != null) {
                return new AbstractFeatureLocking(this.getSupportedHints()){

                    @Override
                    public DataStore getDataStore() {
                        return AbstractDataStore.this;
                    }

                    public String toString() {
                        return "AbstractDataStore.AbstractFeatureLocking(" + string + ")";
                    }

                    @Override
                    public void addFeatureListener(FeatureListener featureListener) {
                        AbstractDataStore.this.listenerManager.addFeatureListener(this, featureListener);
                    }

                    @Override
                    public void removeFeatureListener(FeatureListener featureListener) {
                        AbstractDataStore.this.listenerManager.removeFeatureListener(this, featureListener);
                    }

                    @Override
                    public SimpleFeatureType getSchema() {
                        return simpleFeatureType;
                    }
                };
            }
            return new AbstractFeatureStore(this.getSupportedHints()){

                @Override
                public DataStore getDataStore() {
                    return AbstractDataStore.this;
                }

                public String toString() {
                    return "AbstractDataStore.AbstractFeatureStore(" + string + ")";
                }

                @Override
                public void addFeatureListener(FeatureListener featureListener) {
                    AbstractDataStore.this.listenerManager.addFeatureListener(this, featureListener);
                }

                @Override
                public void removeFeatureListener(FeatureListener featureListener) {
                    AbstractDataStore.this.listenerManager.removeFeatureListener(this, featureListener);
                }

                @Override
                public SimpleFeatureType getSchema() {
                    return simpleFeatureType;
                }
            };
        }
        return new AbstractFeatureSource(this.getSupportedHints()){

            @Override
            public DataStore getDataStore() {
                return AbstractDataStore.this;
            }

            public String toString() {
                return "AbstractDataStore.AbstractFeatureSource(" + string + ")";
            }

            @Override
            public void addFeatureListener(FeatureListener featureListener) {
                AbstractDataStore.this.listenerManager.addFeatureListener(this, featureListener);
            }

            @Override
            public void removeFeatureListener(FeatureListener featureListener) {
                AbstractDataStore.this.listenerManager.removeFeatureListener(this, featureListener);
            }

            @Override
            public SimpleFeatureType getSchema() {
                return simpleFeatureType;
            }
        };
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        FeatureReader<Object, Object> featureReader;
        Filter filter = query.getFilter();
        String string = query.getTypeName();
        String[] stringArray = query.getPropertyNames();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (string == null) {
            throw new NullPointerException("getFeatureReader requires typeName: use getTypeNames() for a list of available types");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        SimpleFeatureType simpleFeatureType = this.getSchema(query.getTypeName());
        if (stringArray != null || query.getCoordinateSystem() != null) {
            try {
                simpleFeatureType = DataUtilities.createSubType(simpleFeatureType, stringArray, query.getCoordinateSystem());
            }
            catch (SchemaException schemaException) {
                LOGGER.log(Level.FINEST, schemaException.getMessage(), schemaException);
                throw new DataSourceException("Could not create Feature Type for query", schemaException);
            }
        }
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader<SimpleFeatureType, SimpleFeature>(simpleFeatureType);
        }
        if ((filter = this.getUnsupportedFilter(string, filter)) == null) {
            throw new NullPointerException("getUnsupportedFilter shouldn't return null. Do you mean Filter.INCLUDE?");
        }
        Diff diff = null;
        if (transaction != Transaction.AUTO_COMMIT && (featureReader = this.state(transaction)) != null) {
            diff = ((TransactionStateDiff)((Object)featureReader)).diff(string);
        }
        featureReader = this.getFeatureReader(string, query);
        if (diff != null) {
            featureReader = new DiffFeatureReader(featureReader, diff, query.getFilter());
        }
        if (!filter.equals(Filter.INCLUDE)) {
            featureReader = new FilteringFeatureReader(featureReader, filter);
        }
        if (!simpleFeatureType.equals(featureReader.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            featureReader = new ReTypeFeatureReader(featureReader, simpleFeatureType, false);
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            featureReader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(featureReader, query.getMaxFeatures());
        }
        return featureReader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String string, Query query) throws IOException {
        return this.getFeatureReader(string);
    }

    protected Filter getUnsupportedFilter(String string, Filter filter) {
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff transactionStateDiff = (TransactionStateDiff)transaction.getState(this);
            if (transactionStateDiff == null) {
                transactionStateDiff = new TransactionStateDiff(this);
                transaction.putState(this, transactionStateDiff);
            }
            return transactionStateDiff;
        }
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Filter filter, Transaction transaction) throws IOException {
        FilteringFeatureWriter filteringFeatureWriter;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (filter == Filter.EXCLUDE) {
            SimpleFeatureType simpleFeatureType = this.getSchema(string);
            return new EmptyFeatureWriter(simpleFeatureType);
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            try {
                filteringFeatureWriter = this.createFeatureWriter(string, transaction);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                try {
                    filteringFeatureWriter = this.getFeatureWriter(string);
                }
                catch (UnsupportedOperationException unsupportedOperationException2) {
                    throw unsupportedOperationException;
                }
            }
        } else {
            TransactionStateDiff transactionStateDiff = this.state(transaction);
            if (transactionStateDiff != null) {
                filteringFeatureWriter = transactionStateDiff.writer(string, filter);
            } else {
                throw new UnsupportedOperationException("Subclass sould implement");
            }
        }
        if (this.lockingManager != null) {
            filteringFeatureWriter = this.lockingManager.checkedWriter(filteringFeatureWriter, transaction);
        }
        if (filter != Filter.INCLUDE) {
            filteringFeatureWriter = new FilteringFeatureWriter(filteringFeatureWriter, filter);
        }
        return filteringFeatureWriter;
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Transaction transaction) throws IOException {
        return this.getFeatureWriter(string, Filter.INCLUDE, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction transaction) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter = this.getFeatureWriter(string, transaction);
        while (featureWriter.hasNext()) {
            featureWriter.next();
        }
        return featureWriter;
    }

    @Override
    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        return null;
    }

    protected int getCount(Query query) throws IOException {
        return -1;
    }

    protected Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void dispose() {
    }
}

