/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Classes;

public final class Logging {
    final String name;

    private Logging() {
        this.name = "";
    }

    private Logging(Logging logging, String string) {
        this.name = string;
        assert (string.startsWith(logging.name)) : string;
    }

    public static Logger getLogger(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = n >= 1 ? string.substring(0, n) : "";
        return Logging.getLogger(string);
    }

    public static Logger getLogger(String string) {
        return Logger.getLogger(string);
    }

    public static boolean unexpectedException(Logger logger, Throwable throwable) {
        return Logging.unexpectedException(logger, null, null, throwable, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.WARNING);
    }

    public static boolean unexpectedException(String string, Class<?> clazz, String string2, Throwable throwable) {
        Logger logger = string != null ? Logging.getLogger(string) : null;
        return Logging.unexpectedException(logger, clazz, string2, throwable);
    }

    public static boolean unexpectedException(Class<?> clazz, String string, Throwable throwable) {
        return Logging.unexpectedException((Logger)null, clazz, string, throwable);
    }

    private static boolean unexpectedException(Logger logger, String string, String string2, Throwable throwable, Level level) {
        Object object;
        if (throwable == null) {
            return false;
        }
        if (logger == null && string != null) {
            int n = string.lastIndexOf(46);
            object = n >= 1 ? string.substring(0, n - 1) : "";
            logger = Logging.getLogger((String)object);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || string == null || string2 == null) {
            String string3 = logger != null ? logger.getName() : null;
            object = throwable.getStackTrace();
            for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                char c;
                StackTraceElement stackTraceElement = object[i];
                String string4 = stackTraceElement.getClassName();
                if (string != null) {
                    if (!string4.equals(string)) {
                        continue;
                    }
                } else if (string3 != null) {
                    if (!string4.startsWith(string3)) continue;
                    int n = string3.length();
                    if (string4.length() > n && Character.isJavaIdentifierPart(c = (char)string4.charAt(n))) continue;
                }
                String string5 = stackTraceElement.getMethodName();
                if (string2 != null && !string5.equals(string2)) continue;
                if (string3 == null && !(logger = Logging.getLogger(string3 = (c = string4.lastIndexOf(46)) >= '\u0001' ? string4.substring(0, c - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (string == null) {
                    string = string4;
                }
                if (string2 != null) break;
                string2 = string5;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(throwable));
        object = throwable.getLocalizedMessage();
        if (object != null) {
            stringBuilder.append(": ").append((String)object);
        }
        LogRecord logRecord = new LogRecord(level, stringBuilder.toString());
        if (string != null) {
            logRecord.setSourceClassName(string);
        }
        if (string2 != null) {
            logRecord.setSourceMethodName(string2);
        }
        if (level.intValue() > 500) {
            logRecord.setThrown(throwable);
        }
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
        return true;
    }

    public static boolean recoverableException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.FINE);
    }
}

