/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class ProjectionAnalyzer {
    private final Conversion projection;
    private final Matrix projectedScale;
    private final MathTransform transform;
    private List<GeneralParameterValue> parameters;

    private ProjectionAnalyzer(ProjectedCRS projectedCRS) {
        Object object;
        Matrix matrix = null;
        Matrix matrix2 = null;
        this.projection = projectedCRS.getConversionFromBase();
        MathTransform mathTransform = this.projection.getMathTransform();
        while (mathTransform instanceof ConcatenatedTransform) {
            object = (ConcatenatedTransform)mathTransform;
            if (((ConcatenatedTransform)object).transform1 instanceof LinearTransform) {
                if (matrix != null) {
                    throw new IllegalStateException(String.valueOf(mathTransform));
                }
                matrix = ((LinearTransform)((ConcatenatedTransform)object).transform1).getMatrix();
                mathTransform = ((ConcatenatedTransform)object).transform2;
                continue;
            }
            if (((ConcatenatedTransform)object).transform2 instanceof LinearTransform) {
                if (matrix2 != null) {
                    throw new IllegalStateException(String.valueOf(mathTransform));
                }
                matrix2 = ((LinearTransform)((ConcatenatedTransform)object).transform2).getMatrix();
                mathTransform = ((ConcatenatedTransform)object).transform1;
                continue;
            }
            mathTransform = null;
            break;
        }
        object = null;
        if (mathTransform instanceof AbstractMathTransform) {
            object = ((AbstractMathTransform)mathTransform).getParameterValues();
        }
        if (object == null) {
            object = this.projection.getParameterValues();
            if (matrix2 == null) {
                CartesianCS cartesianCS = projectedCRS.getCoordinateSystem();
                matrix2 = AbstractCS.swapAndScaleAxis(AbstractCS.standard(cartesianCS), cartesianCS);
            }
        }
        if (object != null) {
            this.parameters = object.values();
        }
        this.projectedScale = matrix2;
        this.transform = mathTransform;
    }

    private ParameterDescriptorGroup getTransformDescriptor() {
        return this.transform instanceof AbstractMathTransform ? ((AbstractMathTransform)this.transform).getParameterDescriptors() : null;
    }

    private XMatrix normalizedToProjection() {
        Object object;
        this.parameters = new LinkedList<GeneralParameterValue>(this.parameters);
        int n = this.transform != null ? this.transform.getTargetDimensions() : 2;
        int n2 = this.projectedScale != null ? this.projectedScale.getNumCol() - 1 : n;
        XMatrix xMatrix = MatrixFactory.create(n2 + 1, n + 1);
        Unit<?> unit = null;
        String string = null;
        Object object2 = this.parameters.iterator();
        while (object2.hasNext()) {
            ParameterValue parameterValue;
            ParameterDescriptor parameterDescriptor;
            object = object2.next();
            if (!(object instanceof ParameterValue) || !Number.class.isAssignableFrom((parameterDescriptor = (parameterValue = (ParameterValue)object).getDescriptor()).getValueClass())) continue;
            if (AbstractIdentifiedObject.nameMatches(parameterDescriptor, "scale_factor")) {
                double d = parameterValue.doubleValue();
                int n3 = Math.min(n, n2);
                while (--n3 >= 0) {
                    xMatrix.setElement(n3, n3, xMatrix.getElement(n3, n3) * d);
                }
            } else {
                int n4;
                if (AbstractIdentifiedObject.nameMatches(parameterDescriptor, "false_easting")) {
                    n4 = 0;
                } else {
                    if (!AbstractIdentifiedObject.nameMatches(parameterDescriptor, "false_northing")) continue;
                    n4 = 1;
                }
                double d = parameterValue.doubleValue(SI.METER);
                if (!Double.isNaN(d) && d != parameterValue.doubleValue()) {
                    unit = parameterValue.getUnit();
                    string = parameterDescriptor.getName().getCode();
                }
                xMatrix.setElement(n4, n, xMatrix.getElement(n4, n) + d);
            }
            object2.remove();
        }
        if (string != null) {
            object2 = Loggings.format(Level.WARNING, 4, string, unit, SI.METER);
            ((LogRecord)object2).setSourceClassName(this.getClass().getName());
            ((LogRecord)object2).setSourceMethodName("createLinearConversion");
            object = ReferencingFactory.LOGGER;
            ((LogRecord)object2).setLoggerName(((Logger)object).getName());
            ((Logger)object).log((LogRecord)object2);
        }
        return xMatrix;
    }

    private static boolean parameterValuesEqual(List<GeneralParameterValue> list, List<GeneralParameterValue> list2, double d) {
        Iterator<GeneralParameterValue> iterator = list2.iterator();
        block0: while (iterator.hasNext()) {
            GeneralParameterValue generalParameterValue = iterator.next();
            Iterator<GeneralParameterValue> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                GeneralParameterValue generalParameterValue2 = iterator2.next();
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue2.getDescriptor(), generalParameterValue.getDescriptor())) continue;
                if (generalParameterValue2 instanceof ParameterValue && generalParameterValue instanceof ParameterValue) {
                    ParameterValue parameterValue = (ParameterValue)generalParameterValue2;
                    ParameterValue parameterValue2 = (ParameterValue)generalParameterValue;
                    if (Number.class.isAssignableFrom(parameterValue2.getDescriptor().getValueClass())) {
                        double d2;
                        double d3;
                        Unit<?> unit = parameterValue2.getUnit();
                        if (unit != null) {
                            d3 = parameterValue.doubleValue(unit);
                            d2 = parameterValue2.doubleValue(unit);
                        } else {
                            d3 = parameterValue.doubleValue();
                            d2 = parameterValue2.doubleValue();
                        }
                        double d4 = d2 - d3;
                        if (d2 != 0.0) {
                            d4 /= d2;
                        }
                        if (!(Math.abs(d4) <= d)) {
                            return false;
                        }
                    } else if (!Utilities.equals(parameterValue.getValue(), parameterValue2.getValue())) {
                        return false;
                    }
                } else if (!Utilities.equals(generalParameterValue, generalParameterValue2)) {
                    return false;
                }
                iterator2.remove();
                iterator.remove();
                continue block0;
            }
            return false;
        }
        assert (list2.isEmpty());
        return list.isEmpty();
    }

    private XMatrix applyProjectedScale(XMatrix xMatrix) {
        if (this.projectedScale == null) {
            return xMatrix;
        }
        XMatrix xMatrix2 = MatrixFactory.create(this.projectedScale);
        xMatrix2.multiply(xMatrix);
        return xMatrix2;
    }

    public static Matrix createLinearConversion(ProjectedCRS projectedCRS, ProjectedCRS projectedCRS2, double d) {
        Object object;
        Object object2;
        if (!CRS.equalsIgnoreMetadata(projectedCRS.getDatum(), projectedCRS2.getDatum())) {
            return null;
        }
        ProjectionAnalyzer projectionAnalyzer = new ProjectionAnalyzer(projectedCRS);
        ProjectionAnalyzer projectionAnalyzer2 = new ProjectionAnalyzer(projectedCRS2);
        if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)projectionAnalyzer.projection.getMethod(), projectionAnalyzer2.projection.getMethod())) {
            object2 = projectionAnalyzer.getTransformDescriptor();
            object = projectionAnalyzer.getTransformDescriptor();
            if (object2 == null || object == null || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)object2, (IdentifiedObject)object)) {
                return null;
            }
        }
        if (projectionAnalyzer.parameters == null || projectionAnalyzer2.parameters == null) {
            return null;
        }
        object2 = projectionAnalyzer.normalizedToProjection();
        object = projectionAnalyzer2.normalizedToProjection();
        if (!ProjectionAnalyzer.parameterValuesEqual(projectionAnalyzer.parameters, projectionAnalyzer2.parameters, d)) {
            return null;
        }
        object = projectionAnalyzer2.applyProjectedScale((XMatrix)object);
        object2 = projectionAnalyzer.applyProjectedScale((XMatrix)object2);
        object2.invert();
        object.multiply((Matrix)object2);
        if (object.isIdentity(d)) {
            object.setIdentity();
        }
        return object;
    }
}

