/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.MatrixParameters;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

public class MatrixParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final int DEFAULT_MATRIX_SIZE = 3;
    private static final int CACHE_SIZE = 8;
    private final ParameterDescriptor<Double>[] parameters = new ParameterDescriptor[64];
    protected final ParameterDescriptor<Integer> numRow;
    protected final ParameterDescriptor<Integer> numCol;
    protected final String prefix;
    protected final char separator;

    public MatrixParameterDescriptors(Map<String, ?> map) {
        this(map, new ParameterDescriptor[]{DefaultParameterDescriptor.create("num_row", 3, 2, 50), DefaultParameterDescriptor.create("num_col", 3, 2, 50)}, "elt_", '_');
    }

    public MatrixParameterDescriptors(Map<String, ?> map, ParameterDescriptor<?>[] parameterDescriptorArray, String string, char c) {
        super(map, (GeneralParameterDescriptor[])parameterDescriptorArray);
        if (parameterDescriptorArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this.numRow = Parameters.cast(parameterDescriptorArray[0], Integer.class);
        this.numCol = Parameters.cast(parameterDescriptorArray[1], Integer.class);
        MatrixParameterDescriptors.ensureNonNull("prefix", string);
        this.prefix = string;
        this.separator = c;
    }

    static void checkIndice(String string, int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Errors.format(58, string, n));
        }
    }

    @Override
    public final GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        return this.descriptor(string, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final GeneralParameterDescriptor descriptor(String string, int n, int n2) throws ParameterNotFoundException {
        int n3;
        MatrixParameterDescriptors.ensureNonNull("name", string);
        string = string.trim();
        RuntimeException runtimeException = null;
        if (string.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (n3 = string.indexOf(this.separator, this.prefix.length())) >= 0) {
            try {
                int n4 = Integer.parseInt(string.substring(this.prefix.length(), n3));
                int n5 = Integer.parseInt(string.substring(n3 + 1));
                return this.descriptor(n4, n5, n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                runtimeException = numberFormatException;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                runtimeException = indexOutOfBoundsException;
            }
        }
        try {
            return super.descriptor(string);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            if (runtimeException != null) {
                try {
                    parameterNotFoundException.initCause(runtimeException);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            throw parameterNotFoundException;
        }
    }

    public final ParameterDescriptor<Double> descriptor(int n, int n2) throws IndexOutOfBoundsException {
        return this.descriptor(n, n2, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final ParameterDescriptor<Double> descriptor(int n, int n2, int n3, int n4) throws IndexOutOfBoundsException {
        ParameterDescriptor<Double> parameterDescriptor;
        MatrixParameterDescriptors.checkIndice("row", n, n3);
        MatrixParameterDescriptors.checkIndice("column", n2, n4);
        int n5 = -1;
        if (n < 8 && n2 < 8 && (parameterDescriptor = this.parameters[n5 = n * 8 + n2]) != null) {
            return parameterDescriptor;
        }
        parameterDescriptor = new DefaultParameterDescriptor<Double>(Collections.singletonMap("name", this.prefix + n + this.separator + n2), Double.class, null, n == n2 ? 1.0 : 0.0, null, null, Unit.ONE, true);
        if (n5 >= 0) {
            this.parameters[n5] = parameterDescriptor;
        }
        return parameterDescriptor;
    }

    @Override
    public final List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors(this.numRow.getDefaultValue(), this.numCol.getDefaultValue());
    }

    final List<GeneralParameterDescriptor> descriptors(int n, int n2) {
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new GeneralParameterDescriptor[n * n2 + 2];
        int n3 = 0;
        generalParameterDescriptorArray[n3++] = this.numRow;
        generalParameterDescriptorArray[n3++] = this.numCol;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                generalParameterDescriptorArray[n3++] = this.descriptor(i, j, n, n2);
            }
        }
        assert (n3 == generalParameterDescriptorArray.length) : n3;
        return UnmodifiableArrayList.wrap(generalParameterDescriptorArray);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new MatrixParameters(this);
    }

    public Matrix getMatrix(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException {
        if (parameterValueGroup instanceof MatrixParameters) {
            return ((MatrixParameters)parameterValueGroup).getMatrix();
        }
        ParameterValue<?> parameterValue = parameterValueGroup.parameter(this.numRow.getName().toString());
        ParameterValue<?> parameterValue2 = parameterValueGroup.parameter(this.numCol.getName().toString());
        int n = parameterValue.intValue();
        int n2 = parameterValue2.intValue();
        XMatrix xMatrix = MatrixFactory.create(n, n2);
        List<GeneralParameterValue> list = parameterValueGroup.values();
        if (list != null) {
            for (GeneralParameterValue generalParameterValue : list) {
                int n3;
                if (generalParameterValue == parameterValue || generalParameterValue == parameterValue2) continue;
                RuntimeException runtimeException = null;
                String string = generalParameterValue.getDescriptor().getName().toString();
                if (string.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (n3 = string.indexOf(this.separator, this.prefix.length())) >= 0) {
                    try {
                        int n4 = Integer.parseInt(string.substring(this.prefix.length(), n3));
                        int n5 = Integer.parseInt(string.substring(n3 + 1));
                        xMatrix.setElement(n4, n5, ((ParameterValue)generalParameterValue).doubleValue());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        runtimeException = numberFormatException;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        runtimeException = indexOutOfBoundsException;
                    }
                }
                InvalidParameterNameException invalidParameterNameException = new InvalidParameterNameException(Errors.format(176, string), string);
                if (runtimeException != null) {
                    invalidParameterNameException.initCause(runtimeException);
                }
                throw invalidParameterNameException;
            }
        }
        return xMatrix;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            MatrixParameterDescriptors matrixParameterDescriptors = (MatrixParameterDescriptors)abstractIdentifiedObject;
            return this.separator == matrixParameterDescriptors.separator && Utilities.equals(this.prefix, matrixParameterDescriptors.prefix);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.prefix.hashCode() ^ 37 * this.separator;
    }
}

