/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.index.quadtree.StoreException;

public class Node {
    protected int numShapesId;
    private boolean visited = false;
    private Envelope bounds;
    protected int[] shapesId;
    protected List subNodes;

    public Node(Envelope envelope) {
        this.bounds = new Envelope(envelope);
        this.subNodes = new ArrayList(4);
        this.shapesId = null;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void setBounds(Envelope envelope) {
        this.bounds = envelope;
    }

    public int getNumSubNodes() {
        return this.subNodes.size();
    }

    public int getNumShapeIds() {
        return this.numShapesId;
    }

    public void addSubNode(Node node) {
        if (node == null) {
            throw new NullPointerException("Cannot add null to subnodes");
        }
        this.subNodes.add(node);
    }

    public boolean removeSubNode(Node node) {
        return this.subNodes.remove(node);
    }

    public void clearSubNodes() {
        this.subNodes.clear();
    }

    public Node getSubNode(int n) throws StoreException {
        return (Node)this.subNodes.get(n);
    }

    public void addShapeId(int n) {
        if (this.shapesId == null) {
            this.shapesId = new int[4];
            Arrays.fill(this.shapesId, -1);
        } else if (this.shapesId.length == this.numShapesId) {
            int[] nArray = new int[(int)Math.ceil((double)this.numShapesId * 3.0 / 2.0)];
            Arrays.fill(nArray, -1);
            System.arraycopy(this.shapesId, 0, nArray, 0, this.numShapesId);
            this.shapesId = nArray;
        }
        this.shapesId[this.numShapesId] = n;
        ++this.numShapesId;
    }

    public int getShapeId(int n) {
        if (n >= this.numShapesId) {
            throw new ArrayIndexOutOfBoundsException("Requsted " + n + " but size = " + this.numShapesId);
        }
        return this.shapesId[n];
    }

    public void setShapesId(int[] nArray) {
        if (nArray == null) {
            this.numShapesId = 0;
        } else {
            this.shapesId = nArray;
            this.numShapesId = 0;
            for (int i = 0; i < nArray.length && nArray[i] != -1; ++i) {
                ++this.numShapesId;
            }
        }
    }

    public int[] getShapesId() {
        return this.shapesId;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    public Node copy() throws IOException {
        Node node = new Node(this.bounds);
        node.setShapesId(this.shapesId);
        node.numShapesId = this.numShapesId;
        return node;
    }

    public void close() {
    }

    public void clean() {
        this.shapesId = null;
        this.numShapesId = 0;
        this.subNodes.clear();
    }

    public void pack() {
        if (this.numShapesId == 0) {
            this.shapesId = null;
        } else if (this.shapesId != null && this.shapesId.length > this.numShapesId) {
            int[] nArray = new int[this.numShapesId];
            System.arraycopy(this.shapesId, 0, nArray, 0, this.numShapesId);
            this.shapesId = nArray;
        }
    }
}

