/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public class ProfileImpl
implements Schema {
    private Schema parent;
    private Set<Name> profile;
    private Map contents = null;

    public ProfileImpl(Schema schema, Set<Name> set) {
        this.parent = schema;
        this.profile = Collections.unmodifiableSet(set);
    }

    @Override
    public Set<Name> keySet() {
        return this.profile;
    }

    @Override
    public String getURI() {
        return this.parent.getURI();
    }

    @Override
    public Schema profile(Set<Name> set) {
        if (!this.profile.containsAll(set)) {
            TreeSet<Name> treeSet = new TreeSet<Name>(set);
            treeSet.removeAll(this.profile);
            throw new IllegalArgumentException("Unable to profile the following names: " + treeSet);
        }
        return this.parent.profile(set);
    }

    @Override
    public int size() {
        return this.profile.size();
    }

    @Override
    public boolean isEmpty() {
        return this.profile.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.profile.contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public AttributeType get(Object object) {
        if (this.profile.contains(object)) {
            return (AttributeType)this.parent.get(object);
        }
        return null;
    }

    @Override
    public AttributeType put(Name name, AttributeType attributeType) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public AttributeType remove(Object object) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public void putAll(Map<? extends Name, ? extends AttributeType> map) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    @Override
    public Collection<AttributeType> values() {
        return this.contents().values();
    }

    @Override
    public Set<Map.Entry<Name, AttributeType>> entrySet() {
        return this.contents().entrySet();
    }

    private synchronized Map<Name, AttributeType> contents() {
        if (this.contents == null) {
            this.contents = new LinkedHashMap();
            for (Name name : this.profile) {
                this.contents.put(name, this.parent.get(name));
            }
        }
        return this.contents;
    }
}

