/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.sncf.datasets;

import java.net.MalformedURLException;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.sncf.SncfConstants;
import org.openstreetmap.josm.plugins.opendata.modules.fr.sncf.SncfLicense;

public abstract class SncfDataSetHandler
extends FrenchDataSetHandler
implements SncfConstants {
    public SncfDataSetHandler(String portalId) {
        this.init(portalId);
    }

    public SncfDataSetHandler(String portalId, String relevantTag) {
        super(relevantTag);
        this.init(portalId);
    }

    public SncfDataSetHandler(String portalId, boolean relevantUnion, String ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    public SncfDataSetHandler(String portalId, String ... relevantTags) {
        this(portalId, false, relevantTags);
    }

    public SncfDataSetHandler(String portalId, boolean relevantUnion, Tag ... relevantTags) {
        super(relevantUnion, relevantTags);
        this.init(portalId);
    }

    private final void init(String portalId) {
        this.setLicense(new SncfLicense());
        if (portalId != null && !portalId.isEmpty()) {
            try {
                this.setLocalPortalURL("http://opendata-test.tumblr.com/" + portalId);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSource() {
        return "SNCF";
    }

    public String getLocalPortalIconName() {
        return "data.fr.sncf_24.png";
    }

    public String getDataLayerIconName() {
        return "data.fr.sncf_16.png";
    }
}

