/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.transport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultSpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;

public class AeroportsHandler
extends DataGouvDataSetHandler {
    private static final Pattern COOR_PATTERN = Pattern.compile("(-?\\p{Digit}+)\u00b0\\p{Space}*(\\p{Digit}+)'\\p{Space}*(\\p{Digit}+)\\p{Space}*((Nord|Sud|Est|Ouest)?)", 2);

    public AeroportsHandler() {
        super("A\u00e9roports-fran\u00e7ais-coordonn\u00e9es-g\u00e9ographiques-30382044");
        this.setName("A\u00e9roports");
        this.setDownloadFileName("coordonn_es g_ographiques a_roports fran_ais v2.xls");
        this.setSpreadSheetHandler((SpreadSheetHandler)new InternalXlsHandler());
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsXlsFilename(filename, new String[]{"coordonn_es g_ographiques a_roports fran_ais v2"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("aeroway", "aerodrome");
        }
    }

    protected class InternalXlsHandler
    extends DefaultSpreadSheetHandler {
        public InternalXlsHandler() {
            this.setLineNumber(4);
            this.setHandlesProjection(true);
        }

        public LatLon getCoor(EastNorth en, String[] fields) {
            Matcher x = COOR_PATTERN.matcher(fields[this.getXCol()]);
            Matcher y = COOR_PATTERN.matcher(fields[this.getYCol()]);
            if (x.matches() && y.matches() && x.groupCount() >= 4 && y.groupCount() >= 4) {
                return new LatLon(this.convertDegreeMinuteSecond(y), this.convertDegreeMinuteSecond(x));
            }
            return null;
        }

        protected double convertDegreeMinuteSecond(Matcher m) {
            Double deg = Double.parseDouble(m.group(1));
            Double min = Double.parseDouble(m.group(2));
            Double sec = Double.parseDouble(m.group(3));
            Double sign = deg < 0.0 || m.groupCount() >= 5 && (m.group(4).equalsIgnoreCase("Sud") || m.group(4).equalsIgnoreCase("Ouest")) ? -1.0 : 1.0;
            if (sign < 0.0) {
                if (deg > 0.0) {
                    deg = deg * sign;
                }
                min = min * sign;
                sec = sec * sign;
            }
            return OdUtils.convertDegreeMinuteSecond((double)deg, (double)min, (double)sec);
        }
    }
}

