/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.MapEntry;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;

public class SoftValueHashMap<K, V>
extends AbstractMap<K, V> {
    static final Logger LOGGER = Logging.getLogger(SoftValueHashMap.class);
    private static final int DEFAULT_HARD_REFERENCE_COUNT = 20;
    private final Map<K, Object> hash = new HashMap<K, Object>();
    private final LinkedList<K> hardCache = new LinkedList();
    private final int hardReferencesCount;
    private transient Set<Map.Entry<K, V>> entries;

    public SoftValueHashMap() {
        this.hardReferencesCount = 20;
    }

    public SoftValueHashMap(int n) {
        this.hardReferencesCount = n;
    }

    private static void ensureNotNull(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, "value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isValid() {
        int n = 0;
        int n2 = 0;
        Map<K, Object> map = this.hash;
        synchronized (map) {
            for (Map.Entry<K, Object> entry : this.hash.entrySet()) {
                if (entry.getValue() instanceof Reference) {
                    ++n;
                } else assert (this.hardCache.contains(entry.getKey()));
                ++n2;
            }
            assert (n2 == this.hash.size());
            assert (this.hardCache.size() == Math.min(n2, this.hardReferencesCount));
        }
        return n == Math.max(n2 - this.hardReferencesCount, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return this.hash.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return this.hash.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        SoftValueHashMap.ensureNotNull(object);
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return super.containsValue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            Object object2;
            Object object3 = this.hash.get(object);
            if (object3 instanceof Reference) {
                if ((object3 = ((Reference)object3).getAndClear()) != null) {
                    object2 = object;
                    this.hash.put(object2, object3);
                    this.retainStrongly(object2);
                } else {
                    this.hash.remove(object);
                }
            }
            object2 = object3;
            return (V)object2;
        }
    }

    private void retainStrongly(K k) {
        assert (Thread.holdsLock(this.hash));
        assert (!this.hardCache.contains(k)) : k;
        this.hardCache.addFirst(k);
        if (this.hardCache.size() > this.hardReferencesCount) {
            K k2 = this.hardCache.removeLast();
            Object object = this.hash.get(k2);
            assert (object != null && !(object instanceof Reference)) : k2;
            Object object2 = object;
            this.hash.put(k2, new Reference<K, Object>(this.hash, k2, object2));
            assert (this.hardCache.size() == this.hardReferencesCount);
        }
        assert (this.isValid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        SoftValueHashMap.ensureNotNull(v);
        Map<K, Object> map = this.hash;
        synchronized (map) {
            Object object = this.hash.put(k, v);
            if (object instanceof Reference) {
                object = ((Reference)object).getAndClear();
            } else if (object != null && !this.hardCache.remove(k)) {
                throw new AssertionError(k);
            }
            this.retainStrongly(k);
            Object object2 = object;
            return (V)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, Object> map2 = this.hash;
        synchronized (map2) {
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            Object object2 = this.hash.remove(object);
            if (object2 instanceof Reference) {
                object2 = ((Reference)object2).getAndClear();
            } else if (object2 != null && !this.hardCache.remove(object)) {
                throw new AssertionError(object);
            }
            Object object3 = object2;
            return (V)object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            for (Object object : this.hash.values()) {
                if (!(object instanceof Reference)) continue;
                ((Reference)object).getAndClear();
            }
            this.hash.clear();
            this.hardCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            if (this.entries == null) {
                this.entries = new Entries();
            }
            return this.entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return super.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Map<K, Object> map = this.hash;
        synchronized (map) {
            return super.toString();
        }
    }

    public static interface ValueCleaner {
        public void clean(Object var1);
    }

    private static final class Reference<K, V>
    extends SoftReference<V> {
        private final Map<K, Object> hash;
        private final K key;
        private ValueCleaner cleaner;

        Reference(Map<K, Object> map, K k, V v) {
            super(v, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.hash = map;
            this.key = k;
        }

        final Object getAndClear() {
            assert (Thread.holdsLock(this.hash));
            Object t = this.get();
            super.clear();
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object;
            if (this.cleaner != null && (object = this.get()) != null) {
                try {
                    this.cleaner.clean(object);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, "Exception occurred while cleaning soft referenced object", throwable);
                }
            }
            super.clear();
            object = this.hash;
            synchronized (object) {
                Object object2 = this.hash.remove(this.key);
                if (object2 != this && object2 != null) {
                    this.hash.put(this.key, object2);
                }
            }
        }
    }

    private static final class Iter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Map<K, Object> hash;
        private final Iterator<Map.Entry<K, Object>> iterator;
        private transient Map.Entry<K, V> entry;

        Iter(Map<K, Object> map) {
            this.hash = map;
            this.iterator = map.entrySet().iterator();
        }

        private boolean findNext() {
            assert (Thread.holdsLock(this.hash));
            while (this.iterator.hasNext()) {
                Map.Entry<K, Object> entry = this.iterator.next();
                Object object = entry.getValue();
                if (object instanceof Reference) {
                    object = ((Reference)object).get();
                    this.entry = new MapEntry<K, Object>(entry.getKey(), object);
                    return true;
                }
                if (object == null) continue;
                this.entry = entry;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Map<K, Object> map = this.hash;
            synchronized (map) {
                return this.entry != null || this.findNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            Map<K, Object> map = this.hash;
            synchronized (map) {
                if (this.entry == null && !this.findNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<K, V> entry = this.entry;
                this.entry = null;
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Map<K, Object> map = this.hash;
            synchronized (map) {
                this.iterator.remove();
            }
        }
    }

    private final class Entries
    extends AbstractSet<Map.Entry<K, V>> {
        private Entries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return new Iter(SoftValueHashMap.this.hash);
            }
        }

        @Override
        public int size() {
            return SoftValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.retainAll(collection);
            }
        }

        @Override
        public void clear() {
            SoftValueHashMap.this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            Map map = SoftValueHashMap.this.hash;
            synchronized (map) {
                return super.toString();
            }
        }
    }
}

