/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public class GrowableInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 5760033376627376937L;
    private static final Map<Locale, Locale> LOCALES = new HashMap<Locale, Locale>();
    private Map<Locale, String> localMap = Collections.emptyMap();
    private transient Set<Locale> localSet;

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        if (string != null) {
            switch (this.localMap.size()) {
                case 0: {
                    this.localMap = Collections.singletonMap(locale, string);
                    this.defaultValue = null;
                    return;
                }
                case 1: {
                    this.localMap = new HashMap<Locale, String>(this.localMap);
                }
            }
            String string2 = this.localMap.get(locale);
            if (string2 != null) {
                if (string.equals(string2)) {
                    return;
                }
                throw new IllegalArgumentException();
            }
            this.localMap.put(locale, string);
            this.defaultValue = null;
        }
    }

    public boolean add(String string, String string2, String string3) throws IllegalArgumentException {
        if (!string2.startsWith(string)) {
            return false;
        }
        int n = string.length();
        int n2 = string2.length();
        String[] stringArray = new String[]{"", "", ""};
        int n3 = 0;
        while (true) {
            int n4;
            if (n == n2) {
                Locale locale = n3 == 0 ? (Locale)null : GrowableInternationalString.unique(new Locale(stringArray[0], stringArray[1], stringArray[2]));
                this.add(locale, string3);
                return true;
            }
            if (string2.charAt(n) != '_' || n3 == stringArray.length) break;
            if ((n4 = string2.indexOf(95, ++n)) < 0) {
                n4 = n2;
            } else if (n4 == n) break;
            int n5 = n;
            n = n4;
            stringArray[n3] = string2.substring(n5, n);
            ++n3;
        }
        throw new IllegalArgumentException(Errors.format(58, "locale", string2.substring(string.length())));
    }

    private static synchronized Locale unique(Locale locale) {
        Object object;
        if (LOCALES.isEmpty()) {
            try {
                object = Locale.class.getFields();
                for (int i = 0; i < ((Field[])object).length; ++i) {
                    Field field = object[i];
                    if (!Modifier.isStatic(field.getModifiers()) || !Locale.class.isAssignableFrom(field.getType())) continue;
                    Locale locale2 = (Locale)field.get(null);
                    LOCALES.put(locale2, locale2);
                }
            }
            catch (Exception exception) {
                Logging.unexpectedException(GrowableInternationalString.class, "unique", exception);
            }
        }
        if ((object = LOCALES.get(locale)) != null) {
            return object;
        }
        LOCALES.put(locale, locale);
        return locale;
    }

    public synchronized Set<Locale> getLocales() {
        if (this.localSet == null) {
            this.localSet = Collections.unmodifiableSet(this.localMap.keySet());
        }
        return this.localSet;
    }

    @Override
    public synchronized String toString(Locale locale) {
        Object object;
        String string;
        while (locale != null) {
            string = this.localMap.get(locale);
            if (string != null) {
                return string;
            }
            object = locale.getLanguage();
            String string2 = locale.getCountry();
            String string3 = locale.getVariant();
            if (string3.length() != 0) {
                locale = new Locale((String)object, string2);
                continue;
            }
            if (string2.length() == 0) break;
            locale = new Locale((String)object);
        }
        if ((string = this.localMap.get(null)) == null && (object = this.localMap.values().iterator()).hasNext()) {
            return (String)object.next();
        }
        return string;
    }

    public boolean isSubsetOf(Object object) {
        if (object instanceof InternationalString) {
            InternationalString internationalString = (InternationalString)object;
            for (Map.Entry<Locale, String> entry : this.localMap.entrySet()) {
                Locale locale = entry.getKey();
                String string = entry.getValue();
                if (string.equals(internationalString.toString(locale))) continue;
                return false;
            }
        } else if (object instanceof CharSequence) {
            String string = object.toString();
            for (String string2 : this.localMap.values()) {
                if (string2.equals(string)) continue;
                return false;
            }
        } else {
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.entrySet().containsAll(this.localMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GrowableInternationalString growableInternationalString = (GrowableInternationalString)object;
            return Utilities.equals(this.localMap, growableInternationalString.localMap);
        }
        return false;
    }

    public int hashCode() {
        return 0x8C44C329 ^ ((Object)this.localMap).hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.localMap.size();
        if (n == 0) {
            return;
        }
        Map.Entry[] entryArray = new Map.Entry[n];
        entryArray = this.localMap.entrySet().toArray(entryArray);
        if (n == 1) {
            Map.Entry entry = entryArray[0];
            this.localMap = Collections.singletonMap(GrowableInternationalString.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localMap.clear();
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                this.localMap.put(GrowableInternationalString.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

