/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.geometry;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public final class ShapeUtilities {
    private static final double EPS = 1.0E-6;
    public static final int PARALLEL = 0;
    public static final int HORIZONTAL = 1;

    private ShapeUtilities() {
    }

    public static Point2D parabolicControlPoint(double d, double d2, double d3, double d4, double d5, double d6, int n, Point2D point2D) throws IllegalArgumentException {
        d3 -= d;
        d4 -= d2;
        d5 -= d;
        d6 -= d2;
        switch (n) {
            case 0: {
                double d7 = d5;
                double d8 = d6;
                d5 = Math.hypot(d5, d6);
                d6 = (d3 * d7 + d4 * d8) / d5;
                d4 = (d4 * d7 - d3 * d8) / d5;
                d3 = d6;
                d6 = 0.0;
                double d9 = d4 * 0.5 * d5 / (d3 * (d5 - d3));
                double d10 = Math.abs(d9);
                if (!(d10 <= 1000000.0)) {
                    return null;
                }
                if (!(d10 >= 1.0E-6)) {
                    return null;
                }
                d3 = 0.5 * d7 - d9 * d8 + d;
                d4 = d9 * d7 + 0.5 * d8 + d2;
                break;
            }
            case 1: {
                double d11 = (d6 - d4 * d5 / d3) / (d5 - d3);
                double d12 = Math.abs(d11);
                if (!(d12 <= 1000000.0)) {
                    return null;
                }
                if (!(d12 >= 1.0E-6)) {
                    return null;
                }
                double d13 = d6 / d5 - d11;
                d3 = (1.0 + d13 / (2.0 * d11)) * d5 - d6 / (2.0 * d11);
                d4 = d2 + d13 * d3;
                d3 += d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (point2D != null) {
            point2D.setLocation(d3, d4);
            return point2D;
        }
        return new Point2D.Double(d3, d4);
    }

    public static Shape toPrimitive(Shape shape) {
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        if (!pathIterator.isDone() && pathIterator.currentSegment(fArray) == 0 && !pathIterator.isDone()) {
            float f = fArray[0];
            float f2 = fArray[1];
            int n = pathIterator.currentSegment(fArray);
            if (pathIterator.isDone()) {
                switch (n) {
                    case 1: {
                        return new Line2D.Float(f, f2, fArray[0], fArray[1]);
                    }
                    case 2: {
                        return new QuadCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3]);
                    }
                    case 3: {
                        return new CubicCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                }
            }
        }
        return shape;
    }
}

