/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedTransformDirect2D
extends ConcatenatedTransformDirect
implements MathTransform2D {
    private static final long serialVersionUID = 6009454091075588885L;
    private final MathTransform2D transform1;
    private final MathTransform2D transform2;

    public ConcatenatedTransformDirect2D(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2) {
        super(mathTransform2D, mathTransform2D2);
        this.transform1 = mathTransform2D;
        this.transform2 = mathTransform2D2;
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 2 && this.getTargetDimensions() == 2;
    }

    @Override
    public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
        assert (this.isValid());
        point2D2 = this.transform1.transform(point2D, point2D2);
        return this.transform2.transform(point2D2, point2D2);
    }

    @Override
    public Shape createTransformedShape(Shape shape) throws TransformException {
        assert (this.isValid());
        return this.transform2.createTransformedShape(this.transform1.createTransformedShape(shape));
    }

    @Override
    public Matrix derivative(Point2D point2D) throws TransformException {
        XMatrix xMatrix = ConcatenatedTransformDirect2D.toXMatrix(this.transform1.derivative(point2D));
        XMatrix xMatrix2 = ConcatenatedTransformDirect2D.toXMatrix(this.transform2.derivative(this.transform1.transform(point2D, null)));
        xMatrix2.multiply(xMatrix);
        return xMatrix2;
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

