/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform;

public class LambertConformal2SP
extends LambertConformal {
    private static final long serialVersionUID = 7184350446186057405L;

    protected LambertConformal2SP(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        super(parameterValueGroup);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3240860802816724947L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Conformal_Conic_2SP"), new NamedIdentifier(Citations.EPSG, "Lambert Conic Conformal (2SP)"), new NamedIdentifier(Citations.ESRI, "Lambert_Conformal_Conic"), new NamedIdentifier(Citations.ESRI, "Lambert_Conformal_Conic_2SP"), new NamedIdentifier(Citations.EPSG, "9802"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic_2SP"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(119))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING, SCALE_FACTOR});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<ConicProjection> getOperationType() {
            return ConicProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            if (Provider.getParameter(STANDARD_PARALLEL_2, parameterValueGroup) == null && Provider.getParameter(STANDARD_PARALLEL_1, parameterValueGroup) == null && Provider.getParameter(LATITUDE_OF_ORIGIN, parameterValueGroup) != null) {
                return new LambertConformal1SP(parameterValueGroup);
            }
            if (Utilities.equals(MathTransformProvider.doubleValue(STANDARD_PARALLEL_1, parameterValueGroup), MathTransformProvider.doubleValue(STANDARD_PARALLEL_2, parameterValueGroup)) && Utilities.equals(MathTransformProvider.doubleValue(STANDARD_PARALLEL_1, parameterValueGroup), MathTransformProvider.doubleValue(LATITUDE_OF_ORIGIN, parameterValueGroup))) {
                return new LambertConformal1SP(parameterValueGroup);
            }
            if (Provider.getParameter(STANDARD_PARALLEL_2, parameterValueGroup) == null && Utilities.equals(MathTransformProvider.doubleValue(STANDARD_PARALLEL_1, parameterValueGroup), MathTransformProvider.doubleValue(LATITUDE_OF_ORIGIN, parameterValueGroup))) {
                return new LambertConformal1SP(parameterValueGroup);
            }
            ParameterValue parameterValue = Provider.getParameter(STANDARD_PARALLEL_1, parameterValueGroup);
            ParameterValue parameterValue2 = Provider.getParameter(STANDARD_PARALLEL_2, parameterValueGroup);
            if (parameterValue != null && parameterValue2 != null && parameterValue.doubleValue() < parameterValue2.doubleValue()) {
                double d = parameterValue.doubleValue();
                parameterValue.setValue(parameterValue2.doubleValue());
                parameterValue2.setValue(d);
            }
            return new LambertConformal2SP(parameterValueGroup);
        }
    }
}

