/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.InternationalString;

public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -98032729598205972L;
    private static final String[] LOCALIZABLES = new String[]{"formula"};
    private final InternationalString formula;
    protected final int sourceDimensions;
    protected final int targetDimensions;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(MathTransform mathTransform) {
        this(DefaultOperationMethod.getProperties(mathTransform), mathTransform.getSourceDimensions(), mathTransform.getTargetDimensions(), DefaultOperationMethod.getDescriptor(mathTransform));
    }

    private static Map<String, ?> getProperties(MathTransform mathTransform) {
        Map<String, Object> map;
        DefaultOperationMethod.ensureNonNull("transform", mathTransform);
        if (mathTransform instanceof AbstractMathTransform) {
            AbstractMathTransform abstractMathTransform = (AbstractMathTransform)mathTransform;
            map = DefaultOperationMethod.getProperties(abstractMathTransform.getParameterDescriptors(), null);
        } else {
            map = Collections.singletonMap("name", Vocabulary.format(230));
        }
        return map;
    }

    private static ParameterDescriptorGroup getDescriptor(MathTransform mathTransform) {
        ParameterDescriptorGroup parameterDescriptorGroup = null;
        if (mathTransform instanceof AbstractMathTransform) {
            parameterDescriptorGroup = ((AbstractMathTransform)mathTransform).getParameterDescriptors();
        }
        return parameterDescriptorGroup;
    }

    public DefaultOperationMethod(OperationMethod operationMethod, int n, int n2) {
        super(operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimensions = n;
        this.targetDimensions = n2;
        DefaultOperationMethod.ensurePositive("sourceDimensions", n);
        DefaultOperationMethod.ensurePositive("targetDimensions", n2);
    }

    public DefaultOperationMethod(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this(map, new HashMap<String, Object>(), n, n2, parameterDescriptorGroup);
    }

    private DefaultOperationMethod(Map<String, ?> map, Map<String, Object> map2, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, map2, LOCALIZABLES);
        this.formula = (InternationalString)map2.get("formula");
        this.parameters = parameterDescriptorGroup;
        this.sourceDimensions = n;
        this.targetDimensions = n2;
        DefaultOperationMethod.ensurePositive("sourceDimensions", n);
        DefaultOperationMethod.ensurePositive("targetDimensions", n2);
    }

    private static void ensurePositive(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(58, string, n));
        }
    }

    @Override
    public InternationalString getFormula() {
        return this.formula;
    }

    @Override
    public int getSourceDimensions() {
        return this.sourceDimensions;
    }

    @Override
    public int getTargetDimensions() {
        return this.targetDimensions;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return this.parameters != null ? this.parameters : Parameters.EMPTY_GROUP;
    }

    Class<? extends Operation> getOperationType() {
        return Projection.class;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultOperationMethod defaultOperationMethod = (DefaultOperationMethod)abstractIdentifiedObject;
            if (this.sourceDimensions == defaultOperationMethod.sourceDimensions && this.targetDimensions == defaultOperationMethod.targetDimensions && DefaultOperationMethod.equals(this.parameters, defaultOperationMethod.parameters, bl)) {
                return !bl || Utilities.equals(this.formula, defaultOperationMethod.formula);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 2012209132 + this.sourceDimensions + 37 * this.targetDimensions;
        if (this.parameters != null) {
            n = n * 37 + this.parameters.hashCode();
        }
        return n;
    }

    private static boolean isTrivial(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)mathTransform).getMatrix();
            int n = matrix.getNumRow();
            if (matrix.getNumCol() == n) {
                for (int i = 0; i < n; ++i) {
                    int n2 = 0;
                    int n3 = 0;
                    for (int j = 0; j < n; ++j) {
                        if (matrix.getElement(i, j) != 0.0) {
                            ++n2;
                        }
                        if (matrix.getElement(j, i) == 0.0) continue;
                        ++n3;
                    }
                    if (n2 == 1 && n3 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void checkDimensions(OperationMethod operationMethod, MathTransform mathTransform) throws MismatchedDimensionException {
        if (operationMethod != null && mathTransform != null) {
            Object object;
            int n;
            int n2 = operationMethod.getSourceDimensions();
            while ((n = mathTransform.getSourceDimensions()) > n2) {
                if (mathTransform instanceof ConcatenatedTransform) {
                    object = (ConcatenatedTransform)mathTransform;
                    if (DefaultOperationMethod.isTrivial(((ConcatenatedTransform)object).transform1)) {
                        mathTransform = ((ConcatenatedTransform)object).transform2;
                        continue;
                    }
                    if (!DefaultOperationMethod.isTrivial(((ConcatenatedTransform)object).transform2)) break;
                    mathTransform = ((ConcatenatedTransform)object).transform1;
                    continue;
                }
                if (!(mathTransform instanceof PassThroughTransform)) break;
                mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
            }
            if (n != n2) {
                object = "sourceDimensions";
            } else {
                n = mathTransform.getTargetDimensions();
                if (n != (n2 = operationMethod.getTargetDimensions())) {
                    object = "targetDimensions";
                } else {
                    return;
                }
            }
            throw new IllegalArgumentException(Errors.format(94, object, n, n2));
        }
    }
}

