/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.DefaultSingleOperation;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;

public class DefaultOperation
extends DefaultSingleOperation
implements Operation {
    private static final long serialVersionUID = -8923365753849532179L;
    protected final OperationMethod method;

    DefaultOperation(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(conversion, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        this.method = conversion.getMethod();
    }

    public DefaultOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
        DefaultOperation.ensureNonNull("method", operationMethod);
        DefaultOperationMethod.checkDimensions(operationMethod, mathTransform);
        this.method = operationMethod;
    }

    public static CoordinateOperation create(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform, OperationMethod operationMethod, Class<? extends CoordinateOperation> clazz) {
        if (operationMethod != null) {
            Class<? extends Operation> clazz2;
            if (operationMethod instanceof MathTransformProvider && (clazz2 = ((MathTransformProvider)operationMethod).getOperationType()) != null && (clazz == null || clazz.isAssignableFrom(clazz2))) {
                clazz = clazz2.asSubclass(clazz);
            }
            if (clazz != null) {
                if (Transformation.class.isAssignableFrom(clazz)) {
                    return new DefaultTransformation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (ConicProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultConicProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (CylindricalProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultCylindricalProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (PlanarProjection.class.isAssignableFrom(clazz)) {
                    return new DefaultPlanarProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (Projection.class.isAssignableFrom(clazz)) {
                    return new DefaultProjection(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
                if (Conversion.class.isAssignableFrom(clazz)) {
                    return new DefaultConversion(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
                }
            }
            return new DefaultOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, operationMethod);
        }
        return new DefaultSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    @Override
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        return DefaultOperation.getParameterValues(this.transform, this.method.getParameters(), true);
    }

    private static ParameterValueGroup getParameterValues(MathTransform mathTransform, ParameterDescriptorGroup parameterDescriptorGroup, boolean bl) {
        while (mathTransform != null) {
            Object object;
            if (mathTransform instanceof ConcatenatedTransform) {
                object = (ConcatenatedTransform)mathTransform;
                ParameterValueGroup parameterValueGroup = DefaultOperation.getParameterValues(((ConcatenatedTransform)object).transform1, parameterDescriptorGroup, false);
                ParameterValueGroup parameterValueGroup2 = DefaultOperation.getParameterValues(((ConcatenatedTransform)object).transform2, parameterDescriptorGroup, false);
                if (parameterValueGroup == null && parameterValueGroup2 != null) {
                    return parameterValueGroup2;
                }
                if (parameterValueGroup2 == null && parameterValueGroup != null) {
                    return parameterValueGroup;
                }
                bl = true;
            }
            if (mathTransform instanceof AbstractMathTransform && (object = ((AbstractMathTransform)mathTransform).getParameterValues()) != null) {
                return object;
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        if (bl) {
            throw new UnsupportedImplementationException(mathTransform.getClass());
        }
        return null;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultOperation defaultOperation = (DefaultOperation)abstractIdentifiedObject;
            if (bl) {
                return DefaultOperation.equals(this.method, defaultOperation.method, bl);
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.method.hashCode();
    }
}

