/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory
implements OptionalFactory {
    final DatumAuthorityFactory datumFactory;
    final CSAuthorityFactory csFactory;
    final CRSAuthorityFactory crsFactory;
    final CoordinateOperationAuthorityFactory operationFactory;

    AuthorityFactoryAdapter(int n) {
        super(n);
        this.datumFactory = null;
        this.csFactory = null;
        this.crsFactory = null;
        this.operationFactory = null;
    }

    protected AuthorityFactoryAdapter(AuthorityFactory authorityFactory) {
        this(authorityFactory, null);
    }

    AuthorityFactoryAdapter(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        this(authorityFactory instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)authorityFactory : (authorityFactory2 instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)authorityFactory2 : null), authorityFactory instanceof CSAuthorityFactory ? (CSAuthorityFactory)authorityFactory : (authorityFactory2 instanceof CSAuthorityFactory ? (CSAuthorityFactory)authorityFactory2 : null), authorityFactory instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)authorityFactory : (authorityFactory2 instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)authorityFactory2 : null), authorityFactory instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)authorityFactory : (authorityFactory2 instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)authorityFactory2 : null));
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory cRSAuthorityFactory, CSAuthorityFactory cSAuthorityFactory, DatumAuthorityFactory datumAuthorityFactory, CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory) {
        super(Math.max(AuthorityFactoryAdapter.getPriority(datumAuthorityFactory), Math.max(AuthorityFactoryAdapter.getPriority(cSAuthorityFactory), Math.max(AuthorityFactoryAdapter.getPriority(cRSAuthorityFactory), AuthorityFactoryAdapter.getPriority(coordinateOperationAuthorityFactory)))));
        if (this instanceof CRSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("crsFactory", cRSAuthorityFactory);
        }
        if (this instanceof CSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("csFactory", cSAuthorityFactory);
        }
        if (this instanceof DatumAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("datumFactory", datumAuthorityFactory);
        }
        if (this instanceof CoordinateOperationAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("opFactory", coordinateOperationAuthorityFactory);
        }
        this.datumFactory = datumAuthorityFactory;
        this.store(Hints.DATUM_AUTHORITY_FACTORY, this.datumFactory);
        this.csFactory = cSAuthorityFactory;
        this.store(Hints.CS_AUTHORITY_FACTORY, this.csFactory);
        this.crsFactory = cRSAuthorityFactory;
        this.store(Hints.CRS_AUTHORITY_FACTORY, this.crsFactory);
        this.operationFactory = coordinateOperationAuthorityFactory;
        this.store(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.operationFactory);
    }

    private static int getPriority(AuthorityFactory authorityFactory) {
        return authorityFactory instanceof AbstractFactory ? ((AbstractFactory)((Object)authorityFactory)).getPriority() : 50;
    }

    private void store(Hints.Key key, AuthorityFactory authorityFactory) {
        if (authorityFactory != null && this.hints.put(key, authorityFactory) != null) {
            throw new AssertionError(key);
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        try {
            object = this.getAuthorityFactory(null);
        }
        catch (FactoryException factoryException) {
            object = factoryException;
        }
        arrayList.add(object);
        return arrayList;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory authorityFactory) {
        if (!this.isCodeMethodOverriden() && AuthorityFactoryAdapter.sameAuthorityCodes(this.crsFactory, authorityFactory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.csFactory, authorityFactory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.datumFactory, authorityFactory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.operationFactory, authorityFactory)) {
            return true;
        }
        return super.sameAuthorityCodes(authorityFactory);
    }

    static boolean sameAuthorityCodes(AuthorityFactory authorityFactory, AuthorityFactory authorityFactory2) {
        if (authorityFactory instanceof AbstractAuthorityFactory && ((AbstractAuthorityFactory)authorityFactory).sameAuthorityCodes(authorityFactory2)) {
            return true;
        }
        return authorityFactory2 == authorityFactory || authorityFactory == null;
    }

    @Override
    public boolean isAvailable() {
        return AuthorityFactoryAdapter.isAvailable(this.crsFactory) && AuthorityFactoryAdapter.isAvailable(this.csFactory) && AuthorityFactoryAdapter.isAvailable(this.datumFactory) && AuthorityFactoryAdapter.isAvailable(this.operationFactory);
    }

    private static boolean isAvailable(AuthorityFactory authorityFactory) {
        return !(authorityFactory instanceof OptionalFactory) || ((OptionalFactory)((Object)authorityFactory)).isAvailable();
    }

    Unit<?> replace(Unit<?> unit) throws FactoryException {
        return unit;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis coordinateSystemAxis) throws FactoryException {
        return coordinateSystemAxis;
    }

    CoordinateSystem replace(CoordinateSystem coordinateSystem) throws FactoryException {
        return coordinateSystem;
    }

    Datum replace(Datum datum) throws FactoryException {
        return datum;
    }

    CoordinateReferenceSystem replace(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        return coordinateReferenceSystem;
    }

    CoordinateOperation replace(CoordinateOperation coordinateOperation) throws FactoryException {
        return coordinateOperation;
    }

    private IdentifiedObject replaceObject(IdentifiedObject identifiedObject) throws FactoryException {
        if (identifiedObject instanceof CoordinateReferenceSystem) {
            return this.replace((CoordinateReferenceSystem)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateSystem) {
            return this.replace((CoordinateSystem)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateSystemAxis) {
            return this.replace((CoordinateSystemAxis)identifiedObject);
        }
        if (identifiedObject instanceof Datum) {
            return this.replace((Datum)identifiedObject);
        }
        if (identifiedObject instanceof CoordinateOperation) {
            return this.replace((CoordinateOperation)identifiedObject);
        }
        return identifiedObject;
    }

    private AbstractAuthorityFactory getGeotoolsFactory(String string, String string2) throws FactoryException {
        AuthorityFactory authorityFactory = this.getAuthorityFactory(string2);
        if (authorityFactory instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)authorityFactory;
        }
        if (string == null) {
            return null;
        }
        throw new FactoryException(Errors.format(52, string));
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory = this.getGeotoolsFactory(null, null);
        return abstractAuthorityFactory != null ? abstractAuthorityFactory.getBackingStoreDescription() : null;
    }

    @Override
    public Citation getVendor() {
        return this.getAuthorityFactory().getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.getAuthorityFactory().getAuthority();
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return this.getAuthorityFactory(null).getAuthorityCodes(clazz);
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return this.getAuthorityFactory(string).getDescriptionText(this.toBackingFactoryCode(string));
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.replaceObject(this.getAuthorityFactory(string).createObject(this.toBackingFactoryCode(string)));
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(string).createDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        return (EngineeringDatum)this.replace(this.getDatumAuthorityFactory(string).createEngineeringDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        return (ImageDatum)this.replace(this.getDatumAuthorityFactory(string).createImageDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        return (VerticalDatum)this.replace(this.getDatumAuthorityFactory(string).createVerticalDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        return (TemporalDatum)this.replace(this.getDatumAuthorityFactory(string).createTemporalDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        return (GeodeticDatum)this.replace(this.getDatumAuthorityFactory(string).createGeodeticDatum(this.toBackingFactoryCode(string)));
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        return this.getDatumAuthorityFactory(string).createEllipsoid(this.toBackingFactoryCode(string));
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        return this.getDatumAuthorityFactory(string).createPrimeMeridian(this.toBackingFactoryCode(string));
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        return this.getGeotoolsFactory("createExtent", string).createExtent(this.toBackingFactoryCode(string));
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCoordinateSystem(this.toBackingFactoryCode(string)));
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        return (CartesianCS)this.replace(this.getCSAuthorityFactory(string).createCartesianCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        return (PolarCS)this.replace(this.getCSAuthorityFactory(string).createPolarCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        return (CylindricalCS)this.replace(this.getCSAuthorityFactory(string).createCylindricalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        return (SphericalCS)this.replace(this.getCSAuthorityFactory(string).createSphericalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        return (EllipsoidalCS)this.replace(this.getCSAuthorityFactory(string).createEllipsoidalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        return (VerticalCS)this.replace(this.getCSAuthorityFactory(string).createVerticalCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        return (TimeCS)this.replace(this.getCSAuthorityFactory(string).createTimeCS(this.toBackingFactoryCode(string)));
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createCoordinateSystemAxis(this.toBackingFactoryCode(string)));
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(string).createUnit(this.toBackingFactoryCode(string)));
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(string).createCoordinateReferenceSystem(this.toBackingFactoryCode(string)));
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return (CompoundCRS)this.replace(this.getCRSAuthorityFactory(string).createCompoundCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return (DerivedCRS)this.replace(this.getCRSAuthorityFactory(string).createDerivedCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return (EngineeringCRS)this.replace(this.getCRSAuthorityFactory(string).createEngineeringCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return (GeographicCRS)this.replace(this.getCRSAuthorityFactory(string).createGeographicCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return (GeocentricCRS)this.replace(this.getCRSAuthorityFactory(string).createGeocentricCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return (ImageCRS)this.replace(this.getCRSAuthorityFactory(string).createImageCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return (ProjectedCRS)this.replace(this.getCRSAuthorityFactory(string).createProjectedCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return (TemporalCRS)this.replace(this.getCRSAuthorityFactory(string).createTemporalCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return (VerticalCRS)this.replace(this.getCRSAuthorityFactory(string).createVerticalCRS(this.toBackingFactoryCode(string)));
    }

    @Override
    public ParameterDescriptor createParameterDescriptor(String string) throws FactoryException {
        return this.getGeotoolsFactory("createParameterDescriptor", string).createParameterDescriptor(this.toBackingFactoryCode(string));
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        return this.getGeotoolsFactory("createOperationMethod", string).createOperationMethod(this.toBackingFactoryCode(string));
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        return this.replace(this.getCoordinateOperationAuthorityFactory(string).createCoordinateOperation(this.toBackingFactoryCode(string)));
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory;
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory2 = this.getCoordinateOperationAuthorityFactory(string);
        if (coordinateOperationAuthorityFactory2 != (coordinateOperationAuthorityFactory = this.getCoordinateOperationAuthorityFactory(string2))) {
            LogRecord logRecord = Loggings.format(Level.WARNING, 29, string, string2);
            logRecord.setSourceMethodName("createFromCoordinateReferenceSystemCodes");
            logRecord.setSourceClassName(AuthorityFactoryAdapter.class.getName());
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
            return Collections.emptySet();
        }
        return coordinateOperationAuthorityFactory2.createFromCoordinateReferenceSystemCodes(this.toBackingFactoryCode(string), this.toBackingFactoryCode(string2));
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new Finder(clazz);
    }

    private FactoryException missingFactory(Class clazz, String string) {
        return new NoSuchAuthorityCodeException(Errors.format(49, clazz), Citations.getIdentifier(this.getAuthority()), this.trimAuthority(string));
    }

    private AuthorityFactory getAuthorityFactory() {
        try {
            return this.getAuthorityFactory(null);
        }
        catch (FactoryException factoryException) {
            throw new IllegalStateException(Errors.format(170), factoryException);
        }
    }

    <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string) throws FactoryException {
        AuthorityFactory authorityFactory;
        if (CRSAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCRSAuthorityFactory(string);
        } else if (CSAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCSAuthorityFactory(string);
        } else if (DatumAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getDatumAuthorityFactory(string);
        } else if (CoordinateOperationAuthorityFactory.class.equals(clazz)) {
            authorityFactory = this.getCoordinateOperationAuthorityFactory(string);
        } else {
            throw new IllegalArgumentException(Errors.format(58, "type", clazz));
        }
        return (T)((AuthorityFactory)clazz.cast(authorityFactory));
    }

    protected AuthorityFactory getAuthorityFactory(String string) throws FactoryException {
        if (this.crsFactory != null) {
            return this.crsFactory;
        }
        if (this.csFactory != null) {
            return this.csFactory;
        }
        if (this.datumFactory != null) {
            return this.datumFactory;
        }
        if (this.operationFactory != null) {
            return this.operationFactory;
        }
        throw this.missingFactory(AuthorityFactory.class, string);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String string) throws FactoryException {
        if (this.datumFactory == null) {
            throw this.missingFactory(DatumAuthorityFactory.class, string);
        }
        return this.datumFactory;
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String string) throws FactoryException {
        if (this.csFactory == null) {
            throw this.missingFactory(CSAuthorityFactory.class, string);
        }
        return this.csFactory;
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String string) throws FactoryException {
        if (this.crsFactory == null) {
            throw this.missingFactory(CRSAuthorityFactory.class, string);
        }
        return this.crsFactory;
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string) throws FactoryException {
        if (this.operationFactory == null) {
            throw this.missingFactory(CoordinateOperationAuthorityFactory.class, string);
        }
        return this.operationFactory;
    }

    protected String toBackingFactoryCode(String string) throws FactoryException {
        return string;
    }

    final boolean isCodeMethodOverriden() {
        Class[] classArray = new Class[]{String.class};
        Class<?> clazz = this.getClass();
        while (!AuthorityFactoryAdapter.class.equals(clazz)) {
            block4: {
                try {
                    clazz.getDeclaredMethod("toBackingFactoryCode", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block4;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    @Override
    public void dispose() throws FactoryException {
        super.dispose();
        this.disposeAbstractAuthorityFactory(this.datumFactory);
        this.disposeAbstractAuthorityFactory(this.csFactory);
        this.disposeAbstractAuthorityFactory(this.crsFactory);
        this.disposeAbstractAuthorityFactory(this.operationFactory);
    }

    private void disposeAbstractAuthorityFactory(Object object) throws FactoryException {
        if (object instanceof AbstractAuthorityFactory) {
            ((AbstractAuthorityFactory)object).dispose();
        }
    }

    class Finder
    extends IdentifiedObjectFinder.Adapter {
        protected Finder(Class<? extends IdentifiedObject> clazz) throws FactoryException {
            super(AuthorityFactoryAdapter.this.getGeotoolsFactory("getIdentifiedObjectFinder", null).getIdentifiedObjectFinder(clazz));
        }

        @Override
        protected IdentifiedObject deriveEquivalent(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) throws FactoryException {
            IdentifiedObject identifiedObject3 = AuthorityFactoryAdapter.this.replaceObject(identifiedObject);
            if (identifiedObject3 != identifiedObject && CRS.equalsIgnoreMetadata(identifiedObject3, identifiedObject2)) {
                return identifiedObject3;
            }
            return super.deriveEquivalent(identifiedObject, identifiedObject2);
        }
    }
}

