/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.Spheroid;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.Ellipsoid;

public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    public static final DefaultEllipsoid WGS84 = DefaultEllipsoid.createFlattenedSphere("WGS84", 6378137.0, 298.257223563, SI.METER);
    public static final DefaultEllipsoid GRS80 = DefaultEllipsoid.createFlattenedSphere("GRS80", 6378137.0, 298.257222101, SI.METER);
    public static final DefaultEllipsoid INTERNATIONAL_1924 = DefaultEllipsoid.createFlattenedSphere("International 1924", 6378388.0, 297.0, SI.METER);
    public static final DefaultEllipsoid CLARKE_1866 = DefaultEllipsoid.createFlattenedSphere("Clarke 1866", 6378206.4, 294.9786982, SI.METER);
    public static final DefaultEllipsoid SPHERE = DefaultEllipsoid.createEllipsoid("SPHERE", 6371000.0, 6371000.0, SI.METER);
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double inverseFlattening;
    private final boolean ivfDefinitive;
    private final Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> map, double d, double d2, double d3, boolean bl, Unit<Length> unit) {
        super(map);
        this.unit = unit;
        this.semiMajorAxis = DefaultEllipsoid.check("semiMajorAxis", d);
        this.semiMinorAxis = DefaultEllipsoid.check("semiMinorAxis", d2);
        this.inverseFlattening = DefaultEllipsoid.check("inverseFlattening", d3);
        this.ivfDefinitive = bl;
        DefaultEllipsoid.ensureNonNull("unit", unit);
        DefaultEllipsoid.ensureLinearUnit(unit);
    }

    public static DefaultEllipsoid createEllipsoid(String string, double d, double d2, Unit<Length> unit) {
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", string), d, d2, unit);
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (d == d2) {
            return new Spheroid(map, d, false, unit);
        }
        return new DefaultEllipsoid(map, d, d2, d / (d - d2), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(String string, double d, double d2, Unit<Length> unit) {
        return DefaultEllipsoid.createFlattenedSphere(Collections.singletonMap("name", string), d, d2, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (Double.isInfinite(d2)) {
            return new Spheroid(map, d, true, unit);
        }
        return new DefaultEllipsoid(map, d, d * (1.0 - 1.0 / d2), d2, true, unit);
    }

    static double check(String string, double d) throws IllegalArgumentException {
        if (d > 0.0) {
            return d;
        }
        throw new IllegalArgumentException(Errors.format(58, string, d));
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)abstractIdentifiedObject;
            return (!bl || this.ivfDefinitive == defaultEllipsoid.ivfDefinitive) && Utilities.equals(this.semiMajorAxis, defaultEllipsoid.semiMajorAxis) && Utilities.equals(this.semiMinorAxis, defaultEllipsoid.semiMinorAxis) && Utilities.equals(this.inverseFlattening, defaultEllipsoid.inverseFlattening) && Utilities.equals(this.unit, defaultEllipsoid.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = 37L * Double.doubleToLongBits(this.semiMajorAxis);
        l = this.ivfDefinitive ? (long)((double)l + this.inverseFlattening) : (long)((double)l + this.semiMinorAxis);
        return (int)(l >>> 32) ^ (int)l;
    }
}

