/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;

final class ParameterValueList
extends AbstractList<GeneralParameterValue>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -7446077551686135264L;
    private final ParameterDescriptorGroup descriptor;
    private final List<GeneralParameterValue> values;

    public ParameterValueList(ParameterDescriptorGroup parameterDescriptorGroup, List<GeneralParameterValue> list) {
        this.descriptor = parameterDescriptorGroup;
        this.values = list;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public GeneralParameterValue get(int n) {
        return this.values.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.values.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.values.lastIndexOf(object);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.values).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    @Override
    public String toString() {
        return this.values.toString();
    }

    @Override
    public boolean add(GeneralParameterValue generalParameterValue) {
        ++this.modCount;
        GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
        List<GeneralParameterDescriptor> list = this.descriptor.descriptors();
        String string = generalParameterDescriptor.getName().getCode();
        if (!list.contains(generalParameterDescriptor)) {
            for (GeneralParameterDescriptor generalParameterDescriptor2 : list) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterDescriptor2, string)) continue;
                throw new IllegalArgumentException(Errors.format(65, string));
            }
            Object object = generalParameterValue instanceof ParameterValue ? ((ParameterValue)generalParameterValue).getValue() : "(group)";
            throw new InvalidParameterNameException(Errors.format(58, string, object), string);
        }
        int n = generalParameterDescriptor.getMaximumOccurs();
        if (n == 1) {
            int n2 = this.values.size();
            while (--n2 >= 0) {
                GeneralParameterValue generalParameterValue2 = this.values.get(n2);
                GeneralParameterDescriptor generalParameterDescriptor3 = generalParameterValue2.getDescriptor();
                if (!generalParameterDescriptor.equals(generalParameterDescriptor3)) continue;
                assert (AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterDescriptor3, string)) : generalParameterValue;
                boolean bl = generalParameterValue.equals(generalParameterValue2);
                this.values.set(n2, generalParameterValue);
                return !bl;
            }
        } else {
            int n3 = 0;
            for (GeneralParameterValue generalParameterValue3 : this.values) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue3.getDescriptor(), string)) continue;
                ++n3;
            }
            if (n3 >= n) {
                throw new InvalidParameterCardinalityException(Errors.format(169, string, n3), string);
            }
        }
        this.values.add(generalParameterValue);
        return true;
    }

    @Override
    public GeneralParameterValue remove(int n) {
        return this.remove(this.values.get(n).getDescriptor(), n);
    }

    private GeneralParameterValue remove(GeneralParameterDescriptor generalParameterDescriptor, int n) {
        GeneralParameterValue generalParameterValue2;
        ++this.modCount;
        int n2 = 0;
        String string = generalParameterDescriptor.getName().getCode();
        for (GeneralParameterValue generalParameterValue2 : this.values) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)generalParameterValue2.getDescriptor(), string)) continue;
            ++n2;
        }
        int n3 = generalParameterDescriptor.getMinimumOccurs();
        if (n2 <= n3) {
            int n4 = generalParameterDescriptor.getMaximumOccurs();
            throw new InvalidParameterCardinalityException(Errors.format(71, string, n2 - 1, n3, n4), string);
        }
        generalParameterValue2 = this.values.remove(n);
        assert (generalParameterValue2 != null && generalParameterDescriptor.equals(generalParameterValue2.getDescriptor())) : generalParameterValue2;
        return generalParameterValue2;
    }
}

