/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import org.geotools.metadata.iso.extent.GeographicExtentImpl;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.GeographicBoundingBox;

public class GeographicBoundingBoxImpl
extends GeographicExtentImpl
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    private static Method toString;
    public static final GeographicBoundingBox WORLD;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public GeographicBoundingBoxImpl() {
    }

    public GeographicBoundingBoxImpl(GeographicBoundingBox geographicBoundingBox) {
        this.setBounds(geographicBoundingBox);
    }

    public GeographicBoundingBoxImpl(double d, double d2, double d3, double d4) {
        super(true);
        this.setBounds(d, d2, d3, d4);
    }

    @Override
    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    @Override
    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    @Override
    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    @Override
    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setBounds(double d, double d2, double d3, double d4) {
        this.checkWritePermission();
        this.westBoundLongitude = d;
        this.eastBoundLongitude = d2;
        this.southBoundLatitude = d3;
        this.northBoundLatitude = d4;
    }

    public void setBounds(GeographicBoundingBox geographicBoundingBox) {
        GeographicBoundingBoxImpl.ensureNonNull("box", geographicBoundingBox);
        this.setInclusion(geographicBoundingBox.getInclusion());
        this.setBounds(geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getNorthBoundLatitude());
    }

    public synchronized void add(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        Boolean bl = this.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", bl);
        Boolean bl2 = geographicBoundingBox.getInclusion();
        GeographicBoundingBoxImpl.ensureNonNull("inclusion", bl2);
        if (bl.booleanValue() == bl2.booleanValue()) {
            if (d < this.westBoundLongitude) {
                this.westBoundLongitude = d;
            }
            if (d2 > this.eastBoundLongitude) {
                this.eastBoundLongitude = d2;
            }
            if (d3 < this.southBoundLatitude) {
                this.southBoundLatitude = d3;
            }
            if (d4 > this.northBoundLatitude) {
                this.northBoundLatitude = d4;
            }
        } else {
            if (d3 <= this.southBoundLatitude && d4 >= this.northBoundLatitude) {
                if (d > this.westBoundLongitude) {
                    this.westBoundLongitude = d;
                }
                if (d2 < this.eastBoundLongitude) {
                    this.eastBoundLongitude = d2;
                }
            }
            if (d <= this.westBoundLongitude && d2 >= this.eastBoundLongitude) {
                if (d3 > this.southBoundLatitude) {
                    this.southBoundLatitude = d3;
                }
                if (d4 < this.northBoundLatitude) {
                    this.northBoundLatitude = d4;
                }
            }
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(GeographicBoundingBoxImpl.class)) {
            GeographicBoundingBoxImpl geographicBoundingBoxImpl = (GeographicBoundingBoxImpl)object;
            return Utilities.equals(this.getInclusion(), geographicBoundingBoxImpl.getInclusion()) && Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(geographicBoundingBoxImpl.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(geographicBoundingBoxImpl.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(geographicBoundingBoxImpl.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(geographicBoundingBoxImpl.westBoundLongitude);
        }
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        if (!this.getClass().equals(GeographicBoundingBoxImpl.class)) {
            return super.hashCode();
        }
        Boolean bl = this.getInclusion();
        int n = bl != null ? bl.hashCode() : 0;
        n += GeographicBoundingBoxImpl.hashCode(this.southBoundLatitude);
        n += GeographicBoundingBoxImpl.hashCode(this.northBoundLatitude);
        n += GeographicBoundingBoxImpl.hashCode(this.eastBoundLongitude);
        return n += GeographicBoundingBoxImpl.hashCode(this.westBoundLongitude);
    }

    private static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)l ^ (int)(l >>> 32);
    }

    @Override
    public String toString() {
        return GeographicBoundingBoxImpl.toString(this, "DD\u00c2\u00b0MM'SS.s\"", null);
    }

    public static String toString(GeographicBoundingBox geographicBoundingBox, String string, Locale locale) {
        if (toString == null) {
            toString = GeographicBoundingBoxImpl.getMethod("toString", new Class[]{GeographicBoundingBox.class, String.class, Locale.class});
        }
        try {
            return String.valueOf(GeographicBoundingBoxImpl.invoke(toString, new Object[]{geographicBoundingBox, string, locale}));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getTargetException());
        }
    }

    private static Method getMethod(String string, Class<?>[] classArray) {
        try {
            return Class.forName("org.geotools.resources.BoundingBoxes").getMethod(string, classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(Errors.format(98, "referencing"), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static Object invoke(Method method, Object[] objectArray) throws InvocationTargetException {
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw invocationTargetException;
        }
    }

    static {
        GeographicBoundingBoxImpl geographicBoundingBoxImpl = new GeographicBoundingBoxImpl(-180.0, 180.0, -90.0, 90.0);
        geographicBoundingBoxImpl.freeze();
        WORLD = geographicBoundingBoxImpl;
    }
}

