/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.Serializable;
import org.geotools.resources.ClassChanger;

public class Angle
implements Comparable<Angle>,
Serializable {
    private static final long serialVersionUID = 1158747349433104534L;
    private final double theta;

    public Angle(double d) {
        this.theta = d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.theta);
        return (int)l ^ (int)(l >>> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            Angle angle = (Angle)object;
            return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(angle.theta);
        }
        return false;
    }

    @Override
    public int compareTo(Angle angle) {
        return Double.compare(this.theta, angle.theta);
    }

    static {
        ClassChanger.register(new ClassChanger<Angle, Double>(Angle.class, Double.class){

            @Override
            protected Double convert(Angle angle) {
                return angle.theta;
            }

            @Override
            protected Angle inverseConvert(Double d) {
                return new Angle(d);
            }
        });
    }
}

