/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.quadtree.IndexStore;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemNode;
import org.geotools.index.quadtree.fs.IndexHeader;
import org.geotools.util.logging.Logging;

public class FileSystemIndexStore
implements IndexStore {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private File file;

    public FileSystemIndexStore(File file) {
        this.file = file;
    }

    @Override
    public QuadTree load(IndexFile indexFile, boolean bl) throws StoreException {
        QuadTree quadTree = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Opening QuadTree " + this.file.getCanonicalPath());
            }
            final FileInputStream fileInputStream = new FileInputStream(this.file);
            final FileChannel fileChannel = fileInputStream.getChannel();
            IndexHeader indexHeader = new IndexHeader(fileChannel);
            ByteOrder byteOrder = FileSystemIndexStore.byteToOrder(indexHeader.getByteOrder());
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.order(byteOrder);
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            quadTree = new QuadTree(byteBuffer.getInt(), byteBuffer.getInt(), indexFile){

                @Override
                public void insert(int n, Envelope envelope) {
                    throw new UnsupportedOperationException("File quadtrees are immutable");
                }

                @Override
                public boolean trim() {
                    return false;
                }

                @Override
                public void close() throws StoreException {
                    super.close();
                    try {
                        fileChannel.close();
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new StoreException(iOException);
                    }
                }
            };
            quadTree.setRoot(FileSystemNode.readNode(0, null, fileChannel, byteOrder, bl));
            LOGGER.finest("QuadTree opened");
        }
        catch (IOException iOException) {
            throw new StoreException(iOException);
        }
        return quadTree;
    }

    private static ByteOrder byteToOrder(byte by) {
        ByteOrder byteOrder = null;
        switch (by) {
            case 0: {
                byteOrder = ByteOrder.nativeOrder();
                break;
            }
            case -1: 
            case 1: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case -2: 
            case 2: {
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
        }
        return byteOrder;
    }
}

