/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.filter.Filters;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.util.Utilities;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class AddImpl
extends MathExpressionImpl
implements Add {
    public AddImpl(Expression expression, Expression expression2) {
        super(expression, expression2);
        this.expressionType = (short)105;
    }

    @Override
    public Object evaluate(Object object) throws IllegalArgumentException {
        this.ensureOperandsSet();
        double d = Filters.number(this.getExpression1().evaluate(object));
        double d2 = Filters.number(this.getExpression2().evaluate(object));
        return this.number(d + d2);
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor, Object object) {
        return expressionVisitor.visit(this, object);
    }

    public boolean equals(Object object) {
        if (object instanceof AddImpl) {
            AddImpl addImpl = (AddImpl)object;
            return Utilities.equals(this.getExpression1(), addImpl.getExpression1()) && Utilities.equals(this.getExpression2(), addImpl.getExpression2());
        }
        return false;
    }

    public int hashCode() {
        int n = 23;
        n = 37 * n + this.getExpression1().hashCode();
        n = 37 * n + this.getExpression2().hashCode();
        return n;
    }

    public String toString() {
        return "(" + this.getExpression1().toString() + "+" + this.getExpression2().toString() + ")";
    }
}

