/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class BBoxExpressionImpl
extends LiteralExpressionImpl
implements BBoxExpression {
    private GeometryFactory gfac = new GeometryFactory();

    protected BBoxExpressionImpl() throws IllegalFilterException {
        this(new Envelope());
    }

    protected BBoxExpressionImpl(Envelope envelope) throws IllegalFilterException {
        this.expressionType = (short)104;
        this.setBounds(envelope);
    }

    @Override
    public final void setBounds(Envelope envelope) throws IllegalFilterException {
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())};
        LinearRing linearRing = null;
        try {
            linearRing = this.gfac.createLinearRing(coordinateArray);
        }
        catch (TopologyException topologyException) {
            throw new IllegalFilterException(topologyException.toString());
        }
        Polygon polygon = this.gfac.createPolygon(linearRing, null);
        if (envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope referencedEnvelope = (ReferencedEnvelope)envelope;
            polygon.setUserData((Object)referencedEnvelope.getCoordinateReferenceSystem());
        }
        super.setValue(polygon);
    }
}

