/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.collection.SubFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class SubFeatureList
extends SubFeatureCollection
implements RandomFeatureAccess {
    List<SortBy> sort;
    List<FeatureId> index;

    public SubFeatureList(SimpleFeatureCollection simpleFeatureCollection, Filter filter) {
        this(simpleFeatureCollection, filter, SortBy.NATURAL_ORDER);
    }

    public SubFeatureList(SimpleFeatureCollection simpleFeatureCollection, SortBy sortBy) {
        this(simpleFeatureCollection, Filter.INCLUDE, sortBy);
    }

    public SubFeatureList(SimpleFeatureCollection simpleFeatureCollection, Filter filter, SortBy sortBy) {
        super(simpleFeatureCollection, filter);
        if (sortBy == null || sortBy.equals(SortBy.NATURAL_ORDER)) {
            this.sort = Collections.emptyList();
        } else {
            this.sort = new ArrayList<SortBy>();
            if (this.collection instanceof SubFeatureList) {
                SubFeatureList subFeatureList = (SubFeatureList)this.collection;
                this.sort.addAll(subFeatureList.sort);
            }
            this.sort.add(sortBy);
        }
        this.index = null;
    }

    public SimpleFeature get(int n) {
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess randomFeatureAccess = (RandomFeatureAccess)this.collection;
            FeatureId featureId = this.index().get(n);
            return randomFeatureAccess.getFeatureMember(featureId.getID());
        }
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            int n2 = 0;
            while (iterator.hasNext()) {
                SimpleFeature simpleFeature = iterator.next();
                if (n2 == n) {
                    SimpleFeature simpleFeature2 = simpleFeature;
                    return simpleFeature2;
                }
                ++n2;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            this.close(iterator);
        }
    }

    @Override
    protected Filter createFilter() {
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> hashSet = new HashSet<FeatureId>();
        Object object = this.index().iterator();
        while (object.hasNext()) {
            hashSet.add(filterFactory.featureId((String)((Object)object.next())));
        }
        object = filterFactory.id(hashSet);
        return object;
    }

    protected List<FeatureId> index() {
        if (this.index == null) {
            this.index = this.createIndex();
        }
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FeatureId> createIndex() {
        ArrayList<FeatureId> arrayList = new ArrayList<FeatureId>();
        Iterator iterator = this.collection.iterator();
        try {
            Object object;
            while (iterator.hasNext()) {
                object = (SimpleFeature)iterator.next();
                if (!this.filter.evaluate(object)) continue;
                arrayList.add(object.getIdentifier());
            }
            if (this.sort != null && !this.sort.isEmpty()) {
                object = this.sort.get(this.sort.size() - 1);
                Collections.sort(arrayList, new Comparator<FeatureId>((SortBy)object){
                    final /* synthetic */ SortBy val$initialOrder;
                    {
                        this.val$initialOrder = sortBy;
                    }

                    @Override
                    public int compare(FeatureId featureId, FeatureId featureId2) {
                        SimpleFeature simpleFeature;
                        SimpleFeature simpleFeature2 = SubFeatureList.this.getFeatureMember(featureId.getID());
                        int n = this.compare(simpleFeature2, simpleFeature = SubFeatureList.this.getFeatureMember(featureId2.getID()), this.val$initialOrder);
                        if (n == 0 && SubFeatureList.this.sort.size() > 1) {
                            for (int i = SubFeatureList.this.sort.size() - 1; n == 0 && i >= 0; --i) {
                                n = this.compare(simpleFeature2, simpleFeature, SubFeatureList.this.sort.get(i));
                            }
                        }
                        return n;
                    }

                    protected int compare(SimpleFeature simpleFeature, SimpleFeature simpleFeature2, SortBy sortBy) {
                        PropertyName propertyName = sortBy.getPropertyName();
                        Comparable comparable = (Comparable)propertyName.evaluate(simpleFeature);
                        Comparable comparable2 = (Comparable)propertyName.evaluate(simpleFeature2);
                        if (sortBy.getSortOrder() == SortOrder.ASCENDING) {
                            return comparable.compareTo(comparable2);
                        }
                        return comparable2.compareTo(comparable);
                    }
                });
            }
        }
        finally {
            this.collection.close(iterator);
        }
        return arrayList;
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        boolean bl = this.collection.add(simpleFeature);
        if (bl) {
            this.index().add(simpleFeature.getIdentifier());
        }
        return true;
    }

    @Override
    public SimpleFeatureCollection subList(Filter filter) {
        if (this.filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (this.filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureList(this.collection, this.ff.and(this.filter, filter), this.sort.get(0));
    }

    @Override
    public SimpleFeature getFeatureMember(String string) throws NoSuchElementException {
        int n = this.index.indexOf(string);
        if (n == -1) {
            throw new NoSuchElementException(string);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess randomFeatureAccess = (RandomFeatureAccess)this.collection;
            randomFeatureAccess.getFeatureMember(string);
        }
        return this.get(n);
    }

    @Override
    public SimpleFeature removeFeatureMember(String string) {
        int n = this.index.indexOf(this.ff.featureId(string));
        if (n == -1) {
            throw new NoSuchElementException(string);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess randomFeatureAccess = (RandomFeatureAccess)this.collection;
            if (this.index != null) {
                this.index.remove(string);
            }
            return randomFeatureAccess.removeFeatureMember(string);
        }
        return this.remove(n);
    }

    public SimpleFeature remove(int n) {
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess randomFeatureAccess = (RandomFeatureAccess)this.collection;
            FeatureId featureId = this.index().get(n);
            return randomFeatureAccess.removeFeatureMember(featureId.getID());
        }
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            int n2 = 0;
            while (iterator.hasNext()) {
                SimpleFeature simpleFeature = iterator.next();
                if (n2 == n) {
                    this.collection.remove(simpleFeature);
                    SimpleFeature simpleFeature2 = simpleFeature;
                    return simpleFeature2;
                }
                ++n2;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            this.close(iterator);
        }
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new SortedIteratory();
    }

    private class SortedIteratory
    implements Iterator<SimpleFeature> {
        Iterator<FeatureId> iterator;
        String id;

        private SortedIteratory() {
            this.iterator = SubFeatureList.this.index().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public SimpleFeature next() {
            FeatureId featureId = this.iterator.next();
            this.id = featureId.getID();
            return SubFeatureList.this.getFeatureMember(this.id);
        }

        @Override
        public void remove() {
            SubFeatureList.this.removeFeatureMember(this.id);
        }
    }
}

