/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.HashMap;
import java.util.Map;
import org.geotools.util.Utilities;
import org.opengis.feature.Property;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;

public abstract class PropertyImpl
implements Property {
    protected Object value;
    protected PropertyDescriptor descriptor;
    protected final Map<Object, Object> userData;

    protected PropertyImpl(Object object, PropertyDescriptor propertyDescriptor) {
        this.value = object;
        this.descriptor = propertyDescriptor;
        this.userData = new HashMap<Object, Object>();
        if (propertyDescriptor == null) {
            throw new NullPointerException("descriptor");
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Name getName() {
        return this.getDescriptor().getName();
    }

    @Override
    public PropertyType getType() {
        return this.getDescriptor().getType();
    }

    @Override
    public boolean isNillable() {
        return this.getDescriptor().isNillable();
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl propertyImpl = (PropertyImpl)object;
        if (!Utilities.equals(this.descriptor, propertyImpl.descriptor)) {
            return false;
        }
        return Utilities.deepEquals(this.value, propertyImpl.value);
    }

    public int hashCode() {
        return 37 * this.descriptor.hashCode() + 37 * (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName()).append(":");
        stringBuffer.append(this.getDescriptor().getName().getLocalPart());
        stringBuffer.append("<");
        stringBuffer.append(this.getDescriptor().getType().getName().getLocalPart());
        stringBuffer.append(">=");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }
}

