/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectingIterator
implements Iterator {
    Iterator delegate;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer tx;

    public ReprojectingIterator(Iterator iterator, MathTransform mathTransform, SimpleFeatureType simpleFeatureType, GeometryCoordinateSequenceTransformer geometryCoordinateSequenceTransformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = iterator;
        this.schema = simpleFeatureType;
        this.tx = geometryCoordinateSequenceTransformer;
        this.tx.setMathTransform(mathTransform);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        SimpleFeature simpleFeature = (SimpleFeature)this.delegate.next();
        try {
            return this.reproject(simpleFeature);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    SimpleFeature reproject(SimpleFeature simpleFeature) throws IOException {
        Object object;
        List<Object> list = simpleFeature.getAttributes();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (!(object instanceof Geometry)) continue;
            Geometry geometry = (Geometry)object;
            try {
                list.set(i, this.tx.transform(geometry));
                continue;
            }
            catch (TransformException transformException) {
                String string = "Error occured transforming " + geometry.toString();
                throw (IOException)new IOException(string).initCause(transformException);
            }
        }
        try {
            return SimpleFeatureBuilder.build(this.schema, list, simpleFeature.getID());
        }
        catch (IllegalAttributeException illegalAttributeException) {
            object = "Error creating reprojeced feature";
            throw (IOException)new IOException((String)object).initCause(illegalAttributeException);
        }
    }
}

