/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.prj;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.resources.NIOUtilities;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PrjFileReader
implements FileReader {
    ByteBuffer buffer;
    ReadableByteChannel channel;
    CharBuffer charBuffer;
    CharsetDecoder decoder;
    StreamLogging streamLogger = new StreamLogging("PRJ reader");
    CoordinateReferenceSystem cs;
    private boolean memoryMapped = true;

    public PrjFileReader(ShpFiles shpFiles) throws IOException {
        Charset charset = Charset.forName("ISO-8859-1");
        this.decoder = charset.newDecoder();
        this.channel = shpFiles.getReadChannel(ShpFileType.PRJ, this);
        this.streamLogger.open();
        this.init();
        this.decoder.decode(this.buffer, this.charBuffer, true);
        this.buffer.limit(this.buffer.capacity());
        this.charBuffer.flip();
        String string = this.charBuffer.toString();
        try {
            this.cs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(string);
        }
        catch (FactoryException factoryException) {
            this.cs = null;
        }
    }

    public CoordinateReferenceSystem getCoodinateSystem() {
        return this.cs;
    }

    private int fill(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        int n = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && n != -1) {
            n = readableByteChannel.read(byteBuffer);
        }
        if (n == -1) {
            byteBuffer.limit(byteBuffer.position());
        }
        return n;
    }

    private void init() throws IOException {
        Object object;
        if (this.channel instanceof FileChannel) {
            object = (FileChannel)this.channel;
            this.buffer = ((FileChannel)object).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)object).size());
            this.buffer.position((int)((FileChannel)object).position());
            this.memoryMapped = true;
        } else {
            int n = 8192;
            this.buffer = NIOUtilities.allocate(n);
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.charBuffer = CharBuffer.allocate(8192);
        object = Charset.forName("ISO-8859-1");
        this.decoder = ((Charset)object).newDecoder();
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            NIOUtilities.clean(this.buffer, this.memoryMapped);
            this.buffer = null;
        }
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
    }
}

