/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.opengis.feature.type.AttributeDescriptor;

public class IndexedShapefileAttributeReader
extends ShapefileAttributeReader {
    protected CloseableIterator<Data> goodRecs;
    private Data next;

    public IndexedShapefileAttributeReader(List<AttributeDescriptor> list, ShapefileReader shapefileReader, IndexedDbaseFileReader indexedDbaseFileReader, CloseableIterator<Data> closeableIterator) {
        this(list.toArray(new AttributeDescriptor[0]), shapefileReader, indexedDbaseFileReader, closeableIterator);
    }

    public IndexedShapefileAttributeReader(AttributeDescriptor[] attributeDescriptorArray, ShapefileReader shapefileReader, IndexedDbaseFileReader indexedDbaseFileReader, CloseableIterator<Data> closeableIterator) {
        super(attributeDescriptorArray, shapefileReader, (DbaseFileReader)indexedDbaseFileReader);
        this.goodRecs = closeableIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.goodRecs != null) {
                this.goodRecs.close();
            }
            this.goodRecs = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.goodRecs != null) {
            while (!this.featureAvailable && this.goodRecs.hasNext()) {
                this.next = (Data)this.goodRecs.next();
                Long l = (Long)this.next.getValue(1);
                this.shp.goTo((int)l.longValue());
                this.record = this.shp.nextRecord();
                Envelope envelope = this.record.envelope();
                if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) {
                    this.geometry = null;
                    continue;
                }
                this.geometry = this.record.shape();
                if (this.dbf != null) {
                    ((IndexedDbaseFileReader)this.dbf).goTo(this.record.number);
                    this.row = this.dbf.readRow();
                } else {
                    this.row = null;
                }
                this.featureAvailable = true;
            }
            return this.featureAvailable;
        }
        return super.hasNext();
    }

    @Override
    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more features in reader");
        }
        this.featureAvailable = false;
    }
}

