/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;

class ShpFilesLocker {
    final URI uri;
    final URL url;
    final FileReader reader;
    final FileWriter writer;
    boolean upgraded;

    public ShpFilesLocker(URL uRL, FileReader fileReader) {
        this.url = uRL;
        this.reader = fileReader;
        this.writer = null;
        this.uri = this.getURI(uRL);
    }

    URI getURI(URL uRL) {
        try {
            return uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public ShpFilesLocker(URL uRL, FileWriter fileWriter) {
        this.url = uRL;
        this.reader = null;
        this.writer = fileWriter;
        this.uri = this.getURI(uRL);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.reader == null ? 0 : this.reader.hashCode());
        n = 31 * n + (this.url == null ? 0 : this.url.hashCode());
        n = 31 * n + (this.writer == null ? 0 : this.writer.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ShpFilesLocker shpFilesLocker = (ShpFilesLocker)object;
        if (this.reader == null ? shpFilesLocker.reader != null : !this.reader.equals(shpFilesLocker.reader)) {
            return false;
        }
        if (this.url == null ? shpFilesLocker.url != null : (this.uri != null ? !this.uri.equals(shpFilesLocker.uri) : !this.url.equals(shpFilesLocker.url))) {
            return false;
        }
        return !(this.writer == null ? shpFilesLocker.writer != null : !this.writer.equals(shpFilesLocker.writer));
    }
}

