/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.directory.DataStoreSoftReference;
import org.geotools.data.directory.DirectoryWatcher;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.directory.ImmediateDirectoryWatcher;
import org.geotools.util.logging.Logging;

class DirectoryTypeCache {
    static final Logger LOGGER = Logging.getLogger(DirectoryTypeCache.class);
    Map<String, FileEntry> ftCache = new ConcurrentHashMap<String, FileEntry>();
    File directory;
    DirectoryWatcher watcher;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    FileStoreFactory factory;

    DirectoryTypeCache(File file, FileStoreFactory fileStoreFactory) throws IOException {
        if (file == null) {
            throw new NullPointerException("Directory parameter should be not null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Specified directory does not exists: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory, it'a s file instead: " + file.getAbsolutePath());
        }
        this.directory = file;
        this.factory = fileStoreFactory;
        this.watcher = new ImmediateDirectoryWatcher(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataStore getDataStore(String string, boolean bl) throws IOException {
        this.lock.readLock().lock();
        try {
            if (bl) {
                this.updateCache();
            }
            DataStore dataStore = this.ftCache.get(string).getStore(true);
            return dataStore;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getTypeNames() throws IOException {
        this.lock.readLock().lock();
        try {
            this.updateCache();
            Set<String> set = this.ftCache.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataStore> getDataStores() {
        ArrayList<DataStore> arrayList = new ArrayList<DataStore>();
        this.lock.readLock().lock();
        try {
            for (FileEntry fileEntry : this.ftCache.values()) {
                try {
                    DataStore dataStore = fileEntry.getStore(false);
                    if (dataStore == null) continue;
                    arrayList.add(dataStore);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, "Error occurred trying to grab a datastore", exception);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() throws IOException {
        if (this.watcher.isStale()) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.watcher.isStale()) {
                    this.watcher.mark();
                    this.refreshCacheContents();
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    void refreshCacheContents() throws IOException {
        Object object;
        TreeMap<String, FileEntry> treeMap = new TreeMap<String, FileEntry>();
        HashMap<File, FileEntry> hashMap = new HashMap<File, FileEntry>();
        for (FileEntry fileEntry : this.ftCache.values()) {
            hashMap.put(fileEntry.file, fileEntry);
        }
        for (File object22 : this.directory.listFiles()) {
            String[] stringArray;
            if (object22.isDirectory()) continue;
            object = (FileEntry)hashMap.get(object22);
            if (object == null && (stringArray = this.factory.getDataStore(object22)) != null) {
                object = new FileEntry(object22, (DataStore)stringArray);
            }
            if (object == null) continue;
            stringArray = ((FileEntry)object).getStore(true).getTypeNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, (FileEntry)object);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Type name " + string + " is available from multiple datastores");
            }
        }
        HashSet<String> hashSet = new HashSet<String>(this.ftCache.keySet());
        hashSet.removeAll(treeMap.keySet());
        HashSet<FileEntry> hashSet2 = new HashSet<FileEntry>();
        Object object3 = hashSet.iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            hashSet2.add(this.ftCache.remove(string));
        }
        for (FileEntry fileEntry : treeMap.values()) {
            hashSet2.remove(fileEntry);
        }
        for (FileEntry fileEntry : hashSet2) {
            fileEntry.dispose();
        }
        object3 = new HashSet(treeMap.keySet());
        object3.removeAll(this.ftCache.keySet());
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.ftCache.put((String)object, (FileEntry)treeMap.get(object));
        }
    }

    void dispose() {
        for (FileEntry fileEntry : this.ftCache.values()) {
            fileEntry.dispose();
        }
    }

    class FileEntry {
        File file;
        SoftReference<DataStore> ref;

        public FileEntry(File file, DataStore dataStore) {
            this.file = file;
            this.ref = new DataStoreSoftReference(dataStore);
        }

        DataStore getStore(boolean bl) throws IOException {
            DataStore dataStore;
            DataStore dataStore2 = dataStore = this.ref != null ? this.ref.get() : null;
            if (dataStore == null && bl) {
                dataStore = DirectoryTypeCache.this.factory.getDataStore(this.file);
                this.ref = new DataStoreSoftReference(dataStore);
            }
            return dataStore;
        }

        void dispose() {
            DataStore dataStore;
            DataStore dataStore2 = dataStore = this.ref != null ? this.ref.get() : null;
            if (dataStore != null) {
                dataStore.dispose();
            }
            this.ref.clear();
        }
    }
}

