/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DelegatingFeatureWriter;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class InProcessLockingManager
implements LockingManager {
    protected Map lockTables = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lockFeatureID(String string, String string2, Transaction transaction, FeatureLock featureLock) throws FeatureLockException {
        Lock lock = this.getLock(string, string2);
        while (lock != null) {
            Lock lock2;
            if (lock instanceof TransactionLock) {
                lock2 = (TransactionLock)lock;
                if (transaction == ((TransactionLock)lock2).transaction) {
                    throw new FeatureLockException("Transaction Lock is already held by this Transaction", string2);
                }
                try {
                    Lock lock3 = lock2;
                    synchronized (lock3) {
                        lock2.wait();
                    }
                    lock = this.getLock(string, string2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new FeatureLockException("Interupted while waiting for Transaction Lock", string2, interruptedException);
                }
            }
            if (lock instanceof MemoryLock) {
                lock2 = (MemoryLock)lock;
                throw new FeatureLockException("Feature Lock is held by Authorization " + ((MemoryLock)lock2).authID, string2);
            }
            throw new FeatureLockException("Lock is already held " + lock, string2);
        }
        lock = this.createLock(transaction, featureLock);
        this.locks(string).put(string2, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getLock(String string, String string2) {
        Map map;
        Map map2 = map = this.locks(string);
        synchronized (map2) {
            if (map.containsKey(string2)) {
                Lock lock = (Lock)map.get(string2);
                if (lock.isExpired()) {
                    map.remove(string2);
                    return null;
                }
                return lock;
            }
            return null;
        }
    }

    protected synchronized Lock createLock(Transaction transaction, FeatureLock featureLock) throws FeatureLockException {
        if (featureLock == FeatureLock.TRANSACTION) {
            if (transaction == Transaction.AUTO_COMMIT) {
                throw new FeatureLockException("We cannot issue a Transaction lock against AUTO_COMMIT");
            }
            TransactionLock transactionLock = (TransactionLock)transaction.getState(this);
            if (transactionLock == null) {
                transactionLock = new TransactionLock();
                transaction.putState(this, transactionLock);
                return transactionLock;
            }
            return transactionLock;
        }
        return new MemoryLock(featureLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map locks(String string) {
        Map map = this.lockTables;
        synchronized (map) {
            if (this.lockTables.containsKey(string)) {
                return (Map)this.lockTables.get(string);
            }
            HashMap hashMap = new HashMap();
            this.lockTables.put(string, hashMap);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set allLocks() {
        Map map = this.lockTables;
        synchronized (map) {
            HashSet hashSet = new HashSet();
            for (Map map2 : this.lockTables.values()) {
                hashSet.addAll(map2.values());
            }
            return hashSet;
        }
    }

    public void assertAccess(String string, String string2, Transaction transaction) throws FeatureLockException {
        Lock lock = this.getLock(string, string2);
        if (lock != null && !lock.isAuthorized(transaction)) {
            throw new FeatureLockException("Transaction does not have authorization for " + string + ":" + string2);
        }
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> checkedWriter(final FeatureWriter<SimpleFeatureType, SimpleFeature> featureWriter, final Transaction transaction) {
        SimpleFeatureType simpleFeatureType = featureWriter.getFeatureType();
        final String string = simpleFeatureType.getTypeName();
        return new DelegatingFeatureWriter<SimpleFeatureType, SimpleFeature>(){
            SimpleFeature live = null;

            @Override
            public SimpleFeatureType getFeatureType() {
                return (SimpleFeatureType)featureWriter.getFeatureType();
            }

            @Override
            public SimpleFeature next() throws IOException {
                this.live = (SimpleFeature)featureWriter.next();
                return this.live;
            }

            @Override
            public void remove() throws IOException {
                if (this.live != null) {
                    InProcessLockingManager.this.assertAccess(string, this.live.getID(), transaction);
                }
                featureWriter.remove();
                this.live = null;
            }

            @Override
            public void write() throws IOException {
                if (this.live != null) {
                    InProcessLockingManager.this.assertAccess(string, this.live.getID(), transaction);
                }
                featureWriter.write();
                this.live = null;
            }

            @Override
            public boolean hasNext() throws IOException {
                this.live = null;
                return featureWriter.hasNext();
            }

            @Override
            public void close() throws IOException {
                this.live = null;
                featureWriter.close();
            }
        };
    }

    @Override
    public synchronized void unLockFeatureID(String string, String string2, Transaction transaction, FeatureLock featureLock) throws IOException {
        this.assertAccess(string, string2, transaction);
        this.locks(string).remove(string2);
    }

    @Override
    public synchronized boolean refresh(String string, Transaction transaction) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + string + ")");
        }
        boolean bl = false;
        Iterator iterator = this.allLocks().iterator();
        while (iterator.hasNext()) {
            Lock lock = (Lock)iterator.next();
            if (lock.isExpired()) {
                iterator.remove();
                continue;
            }
            if (!lock.isMatch(string)) continue;
            if (lock.isAuthorized(transaction)) {
                lock.refresh();
                bl = true;
                continue;
            }
            throw new IOException("Not authorized to refresh " + lock);
        }
        return bl;
    }

    @Override
    public boolean release(String string, Transaction transaction) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + string + ")");
        }
        boolean bl = false;
        for (Map map : this.lockTables.values()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : map.keySet()) {
                Lock lock = (Lock)map.get(string2);
                if (lock.isExpired()) {
                    hashSet.add(string2);
                    continue;
                }
                if (!lock.isMatch(string)) continue;
                if (lock.isAuthorized(transaction)) {
                    hashSet.add(string2);
                    bl = true;
                    continue;
                }
                throw new IOException("Not authorized to release " + lock);
            }
            Iterator<Object> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
        }
        return bl;
    }

    @Override
    public boolean exists(String string) {
        if (string == null) {
            return false;
        }
        Iterator iterator = this.allLocks().iterator();
        while (iterator.hasNext()) {
            Lock lock = (Lock)iterator.next();
            if (lock.isExpired()) {
                iterator.remove();
                continue;
            }
            if (!lock.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    class MemoryLock
    implements Lock {
        String authID;
        long duration;
        long expiry;

        MemoryLock(FeatureLock featureLock) {
            this(featureLock.getAuthorization(), featureLock.getDuration());
        }

        MemoryLock(String string, long l) {
            this.authID = string;
            this.duration = l;
            this.expiry = System.currentTimeMillis() + l;
        }

        @Override
        public boolean isMatch(String string) {
            return this.authID.equals(string);
        }

        @Override
        public void refresh() {
            this.expiry = System.currentTimeMillis() + this.duration;
        }

        @Override
        public boolean isExpired() {
            if (this.duration == 0L) {
                return false;
            }
            long l = System.currentTimeMillis();
            return l >= this.expiry;
        }

        @Override
        public boolean isAuthorized(Transaction transaction) {
            return transaction != Transaction.AUTO_COMMIT && transaction.getAuthorizations().contains(this.authID);
        }

        public String toString() {
            if (this.duration == 0L) {
                return "MemoryLock(" + this.authID + "|PermaLock)";
            }
            long l = System.currentTimeMillis();
            long l2 = this.expiry - l;
            long l3 = this.duration;
            return "MemoryLock(" + this.authID + "|" + l2 + "ms|" + l3 + "ms)";
        }
    }

    class TransactionLock
    implements Lock,
    Transaction.State {
        Transaction transaction;

        TransactionLock() {
        }

        @Override
        public boolean isMatch(String string) {
            return false;
        }

        @Override
        public boolean isExpired() {
            return this.transaction != null;
        }

        @Override
        public void refresh() {
        }

        @Override
        public boolean isAuthorized(Transaction transaction) {
            return this.transaction == transaction;
        }

        public String toString() {
            return "TranasctionLock(" + !this.isExpired() + ")";
        }
    }

    static interface Lock {
        public boolean isExpired();

        public boolean isMatch(String var1);

        public boolean isAuthorized(Transaction var1);

        public void refresh();
    }
}

