/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.TransactionStateDiff;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;

public class Diff {
    private final Map modifiedFeatures = new ConcurrentHashMap();
    private final Map addedFeatures = new ConcurrentHashMap();
    public final Map modified2 = Collections.unmodifiableMap(this.modifiedFeatures);
    public final Map added = Collections.unmodifiableMap(this.addedFeatures);
    public int nextFID = 0;
    private SpatialIndex spatialIndex = new Quadtree();
    Object mutex = this;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String string, SimpleFeature simpleFeature) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature simpleFeature2;
            if (this.addedFeatures.containsKey(string)) {
                simpleFeature2 = (SimpleFeature)this.addedFeatures.get(string);
                this.addedFeatures.put(string, simpleFeature);
            } else {
                simpleFeature2 = (SimpleFeature)this.modifiedFeatures.get(string);
                this.modifiedFeatures.put(string, simpleFeature);
            }
            if (simpleFeature2 != null) {
                this.spatialIndex.remove((Envelope)ReferencedEnvelope.reference(simpleFeature2.getBounds()), (Object)simpleFeature2);
            }
            this.addToSpatialIndex(simpleFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, SimpleFeature simpleFeature) {
        Object object = this.mutex;
        synchronized (object) {
            this.addedFeatures.put(string, simpleFeature);
            this.addToSpatialIndex(simpleFeature);
        }
    }

    protected void addToSpatialIndex(SimpleFeature simpleFeature) {
        BoundingBox boundingBox;
        if (simpleFeature.getDefaultGeometry() != null && !(boundingBox = simpleFeature.getBounds()).isEmpty()) {
            this.spatialIndex.insert((Envelope)ReferencedEnvelope.reference(boundingBox), (Object)simpleFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature simpleFeature = null;
            if (this.addedFeatures.containsKey(string)) {
                simpleFeature = (SimpleFeature)this.addedFeatures.get(string);
                this.addedFeatures.remove(string);
            } else {
                simpleFeature = (SimpleFeature)this.modifiedFeatures.get(string);
                this.modifiedFeatures.put(string, TransactionStateDiff.NULL);
            }
            if (simpleFeature != null) {
                this.spatialIndex.remove((Envelope)ReferencedEnvelope.reference(simpleFeature.getBounds()), (Object)simpleFeature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryIndex(Envelope envelope) {
        Object object = this.mutex;
        synchronized (object) {
            return this.spatialIndex.query(envelope);
        }
    }
}

