/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.ExternSheetNameResolver;
import org.apache.poi.hssf.record.formula.RefPtgBase;
import org.apache.poi.ss.formula.ExternSheetReferenceToken;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class Ref3DPtg
extends RefPtgBase
implements WorkbookDependentFormula,
ExternSheetReferenceToken {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private int field_1_index_extern_sheet;

    public Ref3DPtg(LittleEndianInput littleEndianInput) {
        this.field_1_index_extern_sheet = littleEndianInput.readShort();
        this.readCoordinates(littleEndianInput);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append("sheetIx=").append(this.getExternSheetIndex());
        stringBuffer.append(" ! ");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(58 + this.getPtgClass());
        littleEndianOutput.writeShort(this.getExternSheetIndex());
        this.writeCoordinates(littleEndianOutput);
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public int getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    @Override
    public String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook) {
        return ExternSheetNameResolver.prependSheetName(formulaRenderingWorkbook, this.field_1_index_extern_sheet, this.formatReferenceAsString());
    }

    @Override
    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }
}

