/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.VecMathI18N;
import javax.vecmath.VecMathUtil;

public class GMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2777097312029690941L;
    int nRow;
    int nCol;
    double[][] values;

    public GMatrix(int n, int n2) {
        int n3;
        this.values = new double[n][n2];
        this.nRow = n;
        this.nCol = n2;
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                this.values[n3][i] = 0.0;
            }
        }
        int n4 = n < n2 ? n : n2;
        for (n3 = 0; n3 < n4; ++n3) {
            this.values[n3][n3] = 1.0;
        }
    }

    public GMatrix(int n, int n2, double[] dArray) {
        this.values = new double[n][n2];
        this.nRow = n;
        this.nCol = n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.values[i][j] = dArray[i * n2 + j];
            }
        }
    }

    public final void mul(GMatrix gMatrix) {
        if (this.nCol != gMatrix.nRow || this.nCol != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix0"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                dArray[i][j] = 0.0;
                for (int k = 0; k < this.nCol; ++k) {
                    double[] dArray2 = dArray[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + this.values[i][k] * gMatrix.values[k][j];
                }
            }
        }
        this.values = dArray;
    }

    public final void mul(GMatrix gMatrix, GMatrix gMatrix2) {
        if (gMatrix.nCol != gMatrix2.nRow || this.nRow != gMatrix.nRow || this.nCol != gMatrix2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix1"));
        }
        double[][] dArray = new double[this.nRow][this.nCol];
        for (int i = 0; i < gMatrix.nRow; ++i) {
            for (int j = 0; j < gMatrix2.nCol; ++j) {
                dArray[i][j] = 0.0;
                for (int k = 0; k < gMatrix.nCol; ++k) {
                    double[] dArray2 = dArray[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + gMatrix.values[i][k] * gMatrix2.values[k][j];
                }
            }
        }
        this.values = dArray;
    }

    public final void negate() {
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                this.values[i][j] = -this.values[i][j];
            }
        }
    }

    public final void setIdentity() {
        int n;
        for (n = 0; n < this.nRow; ++n) {
            for (int i = 0; i < this.nCol; ++i) {
                this.values[n][i] = 0.0;
            }
        }
        int n2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        for (n = 0; n < n2; ++n) {
            this.values[n][n] = 1.0;
        }
    }

    public final void setZero() {
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                this.values[i][j] = 0.0;
            }
        }
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void copySubMatrix(int n, int n2, int n3, int n4, int n5, int n6, GMatrix gMatrix) {
        if (this != gMatrix) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    gMatrix.values[n5 + i][n6 + j] = this.values[n + i][n2 + j];
                }
            }
        } else {
            int n7;
            int n8;
            double[][] dArray = new double[n3][n4];
            for (n8 = 0; n8 < n3; ++n8) {
                for (n7 = 0; n7 < n4; ++n7) {
                    dArray[n8][n7] = this.values[n + n8][n2 + n7];
                }
            }
            for (n8 = 0; n8 < n3; ++n8) {
                for (n7 = 0; n7 < n4; ++n7) {
                    gMatrix.values[n5 + n8][n6 + n7] = dArray[n8][n7];
                }
            }
        }
    }

    public final void setSize(int n, int n2) {
        double[][] dArray = new double[n][n2];
        int n3 = this.nRow < n ? this.nRow : n;
        int n4 = this.nCol < n2 ? this.nCol : n2;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                dArray[i][j] = this.values[i][j];
            }
        }
        this.nRow = n;
        this.nCol = n2;
        this.values = dArray;
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int n, int n2) {
        return this.values[n][n2];
    }

    public final void setElement(int n, int n2, double d) {
        this.values[n][n2] = d;
    }

    public final void transpose() {
        if (this.nRow != this.nCol) {
            int n = this.nRow;
            this.nRow = this.nCol;
            this.nCol = n;
            double[][] dArray = new double[this.nRow][this.nCol];
            for (n = 0; n < this.nRow; ++n) {
                for (int i = 0; i < this.nCol; ++i) {
                    dArray[n][i] = this.values[i][n];
                }
            }
            this.values = dArray;
        } else {
            for (int i = 0; i < this.nRow; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d = this.values[i][j];
                    this.values[i][j] = this.values[j][i];
                    this.values[j][i] = d;
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nRow * this.nCol * 8);
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                stringBuffer.append(this.values[i][j]).append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + (long)this.nRow;
        l = 31L * l + (long)this.nCol;
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                l = 31L * l + VecMathUtil.doubleToLongBits(this.values[i][j]);
            }
        }
        return (int)(l ^ l >> 32);
    }

    public boolean equals(GMatrix gMatrix) {
        try {
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            for (int i = 0; i < this.nRow; ++i) {
                for (int j = 0; j < this.nCol; ++j) {
                    if (this.values[i][j] == gMatrix.values[i][j]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            GMatrix gMatrix = (GMatrix)object;
            if (this.nRow != gMatrix.nRow || this.nCol != gMatrix.nCol) {
                return false;
            }
            for (int i = 0; i < this.nRow; ++i) {
                for (int j = 0; j < this.nCol; ++j) {
                    if (this.values[i][j] == gMatrix.values[i][j]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    final void invertGeneral(GMatrix gMatrix) {
        int n;
        int n2;
        int n3 = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int[] nArray = new int[gMatrix.nRow];
        int[] nArray2 = new int[1];
        if (gMatrix.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix22"));
        }
        for (n2 = 0; n2 < this.nRow; ++n2) {
            for (n = 0; n < this.nCol; ++n) {
                dArray[n2 * this.nCol + n] = gMatrix.values[n2][n];
            }
        }
        if (!GMatrix.luDecomposition(gMatrix.nRow, dArray, nArray, nArray2)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.nCol; ++n2) {
            dArray2[n2 + n2 * this.nCol] = 1.0;
        }
        GMatrix.luBacksubstitution(gMatrix.nRow, dArray, nArray, dArray2);
        for (n2 = 0; n2 < this.nRow; ++n2) {
            for (n = 0; n < this.nCol; ++n) {
                this.values[n2][n] = dArray2[n2 * this.nCol + n];
            }
        }
    }

    static boolean luDecomposition(int n, double[] dArray, int[] nArray, int[] nArray2) {
        double d;
        int n2;
        double d2;
        double[] dArray2 = new double[n];
        int n3 = 0;
        int n4 = 0;
        nArray2[0] = 1;
        int n5 = n;
        while (n5-- != 0) {
            d2 = 0.0;
            n2 = n;
            while (n2-- != 0) {
                d = dArray[n3++];
                if (!((d = Math.abs(d)) > d2)) continue;
                d2 = d;
            }
            if (d2 == 0.0) {
                return false;
            }
            dArray2[n4++] = 1.0 / d2;
        }
        int n6 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n7;
            int n8;
            int n9;
            double d3;
            int n10;
            for (n5 = 0; n5 < n2; ++n5) {
                n10 = n6 + n * n5 + n2;
                d3 = dArray[n10];
                n9 = n5;
                n8 = n6 + n * n5;
                n7 = n6 + n2;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += n;
                }
                dArray[n10] = d3;
            }
            d2 = 0.0;
            int n11 = -1;
            for (n5 = n2; n5 < n; ++n5) {
                double d4;
                n10 = n6 + n * n5 + n2;
                d3 = dArray[n10];
                n9 = n2;
                n8 = n6 + n * n5;
                n7 = n6 + n2;
                while (n9-- != 0) {
                    d3 -= dArray[n8] * dArray[n7];
                    ++n8;
                    n7 += n;
                }
                dArray[n10] = d3;
                d = dArray2[n5] * Math.abs(d3);
                if (!(d4 >= d2)) continue;
                d2 = d;
                n11 = n5;
            }
            if (n11 < 0) {
                throw new RuntimeException(VecMathI18N.getString("GMatrix24"));
            }
            if (n2 != n11) {
                n9 = n;
                n8 = n6 + n * n11;
                n7 = n6 + n * n2;
                while (n9-- != 0) {
                    d = dArray[n8];
                    dArray[n8++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n11] = dArray2[n2];
                nArray2[0] = -nArray2[0];
            }
            nArray[n2] = n11;
            if (dArray[n6 + n * n2 + n2] == 0.0) {
                return false;
            }
            if (n2 == n - 1) continue;
            d = 1.0 / dArray[n6 + n * n2 + n2];
            n10 = n6 + n * (n2 + 1) + n2;
            n5 = n - 1 - n2;
            while (n5-- != 0) {
                int n12 = n10;
                dArray[n12] = dArray[n12] * d;
                n10 += n;
            }
        }
        return true;
    }

    static void luBacksubstitution(int n, double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = i;
            int n7 = -1;
            for (n5 = 0; n5 < n; ++n5) {
                int n8 = nArray[n2 + n5];
                double d = dArray2[n6 + n * n8];
                dArray2[n6 + n * n8] = dArray2[n6 + n * n5];
                if (n7 >= 0) {
                    n4 = n5 * n;
                    for (n3 = n7; n3 <= n5 - 1; ++n3) {
                        d -= dArray[n4 + n3] * dArray2[n6 + n * n3];
                    }
                } else if (d != 0.0) {
                    n7 = n5;
                }
                dArray2[n6 + n * n5] = d;
            }
            for (n5 = 0; n5 < n; ++n5) {
                int n9 = n - 1 - n5;
                n4 = n * n9;
                double d = 0.0;
                for (n3 = 1; n3 <= n5; ++n3) {
                    d += dArray[n4 + n - n3] * dArray2[n6 + n * (n - n3)];
                }
                dArray2[n6 + n * n9] = (dArray2[n6 + n * n9] - d) / dArray[n4 + n9];
            }
        }
    }

    public Object clone() {
        GMatrix gMatrix = null;
        try {
            gMatrix = (GMatrix)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        gMatrix.values = new double[this.nRow][this.nCol];
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                gMatrix.values[i][j] = this.values[i][j];
            }
        }
        return gMatrix;
    }
}

