/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.HashMap;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;

public class BaseUnit<Q extends Quantity>
extends Unit<Q> {
    private final String _symbol;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseUnit(String string) {
        this._symbol = string;
        HashMap<String, Unit<?>> hashMap = Unit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            Unit<?> unit = Unit.SYMBOL_TO_UNIT.get(string);
            if (unit == null) {
                Unit.SYMBOL_TO_UNIT.put(string, this);
                return;
            }
            if (!(unit instanceof BaseUnit)) {
                throw new IllegalArgumentException("Symbol " + string + " is associated to a different unit");
            }
        }
    }

    public final String getSymbol() {
        return this._symbol;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseUnit)) {
            return false;
        }
        BaseUnit baseUnit = (BaseUnit)object;
        return this._symbol.equals(baseUnit._symbol);
    }

    @Override
    public int hashCode() {
        return this._symbol.hashCode();
    }

    @Override
    public Unit<? super Q> getStandardUnit() {
        return this;
    }

    @Override
    public UnitConverter toStandardUnit() {
        return UnitConverter.IDENTITY;
    }
}

