/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.regex.Pattern;

public class Version
implements CharSequence,
Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -6793384507333713770L;
    private static final Pattern PATTERN = Pattern.compile("(\\.|\\-)");
    private final String version;
    private transient String[] components;
    private transient Comparable<?>[] parsed;
    private transient int hashCode;

    public Version(String string) {
        this.version = string.trim();
    }

    public synchronized Comparable<?> getComponent(int n) {
        if (this.parsed == null) {
            if (this.components == null) {
                this.components = PATTERN.split(this.version);
            }
            this.parsed = new Comparable[this.components.length];
        }
        if (n >= this.parsed.length) {
            return null;
        }
        Object object = this.parsed[n];
        if (object == null) {
            String string = this.components[n].trim();
            try {
                object = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = string;
            }
            this.parsed[n] = object;
        }
        return object;
    }

    private static int getTypeRank(Object object) {
        if (object instanceof CharSequence) {
            return 0;
        }
        if (object instanceof Number) {
            return 1;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public int compareTo(Version version, int n) {
        for (int i = 0; i < n; ++i) {
            Comparable<?> comparable = this.getComponent(i);
            Comparable<?> comparable2 = version.getComponent(i);
            if (comparable == null) {
                return comparable2 == null ? 0 : -1;
            }
            if (comparable2 == null) {
                return 1;
            }
            int n2 = Version.getTypeRank(comparable) - Version.getTypeRank(comparable2);
            if (n2 != 0) {
                return n2;
            }
            int n3 = comparable.compareTo(comparable2);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    @Override
    public int compareTo(Version version) {
        return this.compareTo(version, Integer.MAX_VALUE);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            return this.compareTo((Version)object) == 0;
        }
        return false;
    }

    @Override
    public int length() {
        return this.version.length();
    }

    @Override
    public char charAt(int n) {
        return this.version.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.version.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Comparable<?> comparable;
            int n = -1849991018;
            int n2 = 0;
            while ((comparable = this.getComponent(n2)) != null) {
                n = n * 37 + comparable.hashCode();
                ++n2;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }
}

