/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.LoggedFormat;

public final class Element {
    private final int offset;
    public final String keyword;
    private final List<Object> list;

    Element(Element element) {
        this.offset = 0;
        this.keyword = null;
        this.list = new LinkedList<Object>();
        this.list.add(element);
    }

    Element(AbstractParser abstractParser, String string, ParsePosition parsePosition) throws ParseException {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = parsePosition.getIndex(); n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        this.offset = n2;
        for (n = n2; n < n3 && Character.isUnicodeIdentifierPart(string.charAt(n)); ++n) {
        }
        if (n <= n2) {
            parsePosition.setErrorIndex(n2);
            throw this.unparsableString(string, parsePosition);
        }
        this.keyword = string.substring(n2, n).toUpperCase(abstractParser.symbols.locale);
        parsePosition.setIndex(n);
        int n4 = -1;
        do {
            if (++n4 < abstractParser.symbols.openingBrackets.length) continue;
            this.list = null;
            return;
        } while (!Element.parseOptionalSeparator(string, parsePosition, abstractParser.symbols.openingBrackets[n4]));
        this.list = new LinkedList<Object>();
        do {
            if (parsePosition.getIndex() >= n3) {
                throw this.missingCharacter(abstractParser.symbols.close, n3);
            }
            if (Element.parseOptionalSeparator(string, parsePosition, abstractParser.symbols.quote)) {
                n2 = parsePosition.getIndex();
                n = string.indexOf(abstractParser.symbols.quote, n2);
                if (n < n2) {
                    parsePosition.setErrorIndex(++n2);
                    throw this.missingCharacter(abstractParser.symbols.quote, n2);
                }
                this.list.add(string.substring(n2, n).trim());
                parsePosition.setIndex(n + 1);
                continue;
            }
            n2 = parsePosition.getIndex();
            if (!Character.isUnicodeIdentifierStart(string.charAt(n2))) {
                Number number = abstractParser.parseNumber(string, parsePosition);
                if (number == null) {
                    throw this.unparsableString(string, parsePosition);
                }
                this.list.add(number);
                continue;
            }
            this.list.add(new Element(abstractParser, string, parsePosition));
        } while (Element.parseOptionalSeparator(string, parsePosition, abstractParser.symbols.separator));
        this.parseSeparator(string, parsePosition, abstractParser.symbols.closingBrackets[n4]);
    }

    private static boolean parseOptionalSeparator(String string, ParsePosition parsePosition, char c) {
        int n;
        int n2 = string.length();
        for (n = parsePosition.getIndex(); n < n2; ++n) {
            char c2 = string.charAt(n);
            if (Character.isWhitespace(c2)) {
                continue;
            }
            if (c2 != c) break;
            parsePosition.setIndex(++n);
            return true;
        }
        parsePosition.setIndex(n);
        return false;
    }

    private void parseSeparator(String string, ParsePosition parsePosition, char c) throws ParseException {
        if (!Element.parseOptionalSeparator(string, parsePosition, c)) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            throw this.unparsableString(string, parsePosition);
        }
    }

    public ParseException parseFailed(Exception exception, String string) {
        if (string == null) {
            string = exception.getLocalizedMessage();
        }
        ParseException parseException = new ParseException(this.complete(string), this.offset);
        parseException = Element.trim("parseFailed", parseException);
        parseException.initCause(exception);
        return parseException;
    }

    private ParseException unparsableString(String string, ParsePosition parsePosition) {
        int n = parsePosition.getErrorIndex();
        String string2 = LoggedFormat.formatUnparsable(string, parsePosition.getIndex(), n, null);
        string2 = this.complete(string2);
        return Element.trim("unparsableString", new ParseException(string2, n));
    }

    private ParseException missingCharacter(char c, int n) {
        return Element.trim("missingCharacter", new ParseException(this.complete(Errors.format(97, Character.valueOf(c))), n));
    }

    private ParseException missingParameter(String string) {
        int n = this.offset;
        if (this.keyword != null) {
            n += this.keyword.length();
        }
        return Element.trim("missingParameter", new ParseException(this.complete(Errors.format(99, string)), n));
    }

    private String complete(String string) {
        if (this.keyword != null) {
            string = Errors.format(84, this.keyword) + ' ' + string;
        }
        return string;
    }

    private static ParseException trim(String string, ParseException parseException) {
        StackTraceElement[] stackTraceElementArray = parseException.getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length != 0 && string.equals(stackTraceElementArray[0].getMethodName())) {
            stackTraceElementArray = XArray.remove(stackTraceElementArray, 0, 1);
            parseException.setStackTrace(stackTraceElementArray);
        }
        return parseException;
    }

    public boolean isRoot() {
        return this.offset == 0;
    }

    public double pullDouble(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingParameter(string);
    }

    public int pullInteger(String string) throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new ParseException(this.complete(Errors.format(58, string, number)), this.offset);
            }
            return number.intValue();
        }
        throw this.missingParameter(string);
    }

    public String pullString(String string) throws ParseException {
        String string2 = this.pullOptionalString(string);
        if (string2 != null) {
            return string2;
        }
        throw this.missingParameter(string);
    }

    public String pullOptionalString(String string) {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        return null;
    }

    public Element pullElement(String string) throws ParseException {
        Element element = this.pullOptionalElement(string);
        if (element != null) {
            return element;
        }
        throw this.missingParameter(string);
    }

    public Element pullOptionalElement(String string) {
        string = string.toUpperCase();
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list == null || !element.keyword.equals(string)) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public Element pullOptionalVoidElement() throws ParseException {
        Iterator<Object> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.list != null) continue;
            iterator.remove();
            return element;
        }
        return null;
    }

    public Object peek() {
        return this.list.isEmpty() ? null : this.list.get(0);
    }

    public void close() throws ParseException {
        if (this.list != null && !this.list.isEmpty()) {
            throw new ParseException(this.complete(Errors.format(176, this.list.get(0))), this.offset + this.keyword.length());
        }
    }

    public String toString() {
        return this.keyword;
    }
}

